/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.baseview;

import com.ur.swing.baseview.AccordionMenuAddedListener;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class AccordionMenuHeader<T extends Enum<T>>
implements Menu {
    protected Map<T, MenuExtension.EnumMenuContribution<T>> contributionMap = new HashMap<T, MenuExtension.EnumMenuContribution<T>>();
    private AccordionMenuAddedListener<T> menuAddedListenerListener;

    @Inject
    public AccordionMenuHeader() {
    }

    @Override
    public void addMenuItem(MenuExtension.MenuContribution menuItemContribution) {
        if (!(menuItemContribution instanceof MenuExtension.EnumMenuContribution)) {
            throw new UnsupportedOperationException("Not an EnumMenuContribution");
        }
        MenuExtension.EnumMenuContribution menuItem = (MenuExtension.EnumMenuContribution)menuItemContribution;
        if (this.contributionMap.containsKey(menuItem.getMenuCategory())) {
            throw new UnsupportedOperationException("Accordion Menu may only contain one header contribution per category: " + menuItem.getMenuCategory());
        }
        this.contributionMap.put(menuItem.getMenuCategory(), menuItem);
        this.notifyListeners(menuItem);
    }

    public void setOnAddedListener(AccordionMenuAddedListener<T> modifiedListener) {
        this.menuAddedListenerListener = modifiedListener;
    }

    protected void notifyListeners(MenuExtension.EnumMenuContribution<T> contribution) {
        if (this.menuAddedListenerListener != null) {
            this.menuAddedListenerListener.onAdded(contribution);
        }
    }
}

