/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.baseview;

import com.ur.swing.baseview.AccordionMenuAddedListener;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class AccordionMenuItem<T extends Enum<T>>
implements Menu {
    protected Map<T, List<MenuExtension.EnumMenuContribution<T>>> contributionMap = new HashMap<T, List<MenuExtension.EnumMenuContribution<T>>>();
    private AccordionMenuAddedListener menuAddedListener;

    @Inject
    public AccordionMenuItem() {
    }

    @Override
    public void addMenuItem(MenuExtension.MenuContribution menuItemContribution) {
        if (!(menuItemContribution instanceof MenuExtension.EnumMenuContribution)) {
            throw new UnsupportedOperationException("Not an EnumMenuContribution");
        }
        MenuExtension.EnumMenuContribution menuItem = (MenuExtension.EnumMenuContribution)menuItemContribution;
        ArrayList<MenuExtension.EnumMenuContribution> newList = new ArrayList<MenuExtension.EnumMenuContribution>();
        newList.add(menuItem);
        if (this.contributionMap.get(menuItem.getMenuCategory()) != null) {
            newList.addAll((Collection)this.contributionMap.get(menuItem.getMenuCategory()));
        }
        this.contributionMap.put(menuItem.getMenuCategory(), newList);
        this.notifyListeners(menuItem);
    }

    List<MenuExtension.EnumMenuContribution<T>> getContributions(T category) {
        return this.contributionMap.get(category);
    }

    public void setOnAddedListener(AccordionMenuAddedListener modifiedListener) {
        this.menuAddedListener = modifiedListener;
    }

    protected void notifyListeners(MenuExtension.EnumMenuContribution<T> contribution) {
        if (this.menuAddedListener != null) {
            this.menuAddedListener.onAdded(contribution);
        }
    }
}

