/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.baseview;

import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.BaseView;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.ShowScreenAction;
import com.ur.swing.URFontFactory;
import com.ur.swing.Veto;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.baseview.AccordionView;
import com.ur.swing.resources.ImageResource;
import com.ur.util.ArrayUtils;
import com.ur.util.IterableEnumerationWrapper;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jdesktop.swingx.VerticalLayout;

public class BaseAccordionView
extends BaseView
implements AccordionView {
    private static final int MAXIMUM_TEXT_WIDTH = 120;
    private static final String SCROLL_BAR_OF_BASEACCORDIONVIEW = "scrollBar." + BaseAccordionView.class.getSimpleName();
    protected final WidgetFactory factory;
    private final ViewContext viewContext;
    private final JPanel content;
    private final Map<AbstractButton, JComponent> completeSet = new HashMap<AbstractButton, JComponent>();
    private final Map<JComponent, ButtonGroup> buttonGroups = new HashMap<JComponent, ButtonGroup>();
    private final ButtonGroup buttonGroup;
    private final JScrollPane scrollPane;
    private final List<Veto> vetoList = new ArrayList<Veto>();
    private LanguageConfiguration.SupportedLanguage language;

    @Inject
    public BaseAccordionView(ViewContext viewContext) {
        this.viewContext = viewContext;
        this.factory = viewContext.createWidgetFactory();
        this.buttonGroup = new ButtonGroup();
        this.content = new JPanel((LayoutManager)new VerticalLayout(1));
        this.scrollPane = new JScrollPane(this.content);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(28, 0));
        this.scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 28));
        this.scrollPane.setWheelScrollingEnabled(true);
        this.scrollPane.setName(SCROLL_BAR_OF_BASEACCORDIONVIEW);
        this.setMinimumSize(UIManager.getDimension("AccordionView.dimensions"));
        this.setContent(this.scrollPane);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setExitAction(Action action) {
        JButton exitButton = this.factory.createButton(action);
        exitButton.setHorizontalAlignment(2);
        exitButton.setPreferredSize(new Dimension(185, 35));
        JPanel header = new JPanel();
        this.viewContext.createToolBarBuilder(header).add(exitButton).toLeft();
        header.setBackground(Color.DARK_GRAY);
        this.setHeader(header);
    }

    @Override
    public void addItem(Action action) {
        action.putValue("Function", (Object)ActionDefinition.Function.SECTION_HEADER);
        JToggleButton section = this.factory.createToggleButton(action);
        section.addItemListener(new ShowSelectionMeWhenClicked(action, this.buttonGroup));
        action.putValue("SmallIcon", ImageResource.navigationItemUnselected());
        if (this.content.getComponentCount() == 0) {
            action.putValue("SmallIcon", ImageResource.navigationItemSelected());
            section.setSelected(true);
        }
        this.buttonGroup.add(section);
        this.content.add(section);
    }

    @Override
    public final AbstractButton addSection(String sectionTitle, JComponent subComponent) {
        return this.addSection((Action)new AbstractActionDefinition(sectionTitle){
            {
                this.putValue("Name", string);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }, subComponent);
    }

    @Override
    public void removeSection(AbstractButton sectionHeader) {
        if (sectionHeader != null) {
            JComponent subComponent = this.completeSet.get(sectionHeader);
            this.content.remove(sectionHeader);
            this.content.remove(subComponent);
            this.completeSet.remove(sectionHeader);
            this.buttonGroup.remove(sectionHeader);
        }
    }

    @Override
    public AbstractButton addSection(Action action, JComponent subComponent) {
        action.putValue("Function", (Object)ActionDefinition.Function.SECTION_HEADER);
        JToggleButton sectionHeader = this.factory.createToggleButton(action);
        sectionHeader.addActionListener(new CollapseOthersAndShowMeWhenClicked(action, subComponent, this.completeSet, this.buttonGroup, this.vetoList));
        action.putValue("SmallIcon", ImageResource.menuCollapse());
        subComponent.setVisible(false);
        if (this.content.getComponentCount() == 0) {
            action.putValue("SmallIcon", ImageResource.menuExpand());
            sectionHeader.setSelected(true);
            subComponent.setVisible(true);
        }
        this.content.add(sectionHeader);
        this.content.add(subComponent);
        this.completeSet.put(sectionHeader, subComponent);
        this.buttonGroup.add(sectionHeader);
        return sectionHeader;
    }

    @Override
    public AbstractButton addSection(Action sectionAction, Action ... subSectionActions) {
        return this.addSection(sectionAction, (JComponent)this.createPanelOfToggleButtons(this.factory, subSectionActions));
    }

    @Override
    public AbstractButton addElementToSection(AbstractButton headerButton, Action action) {
        JComponent component = this.completeSet.get(headerButton);
        ButtonGroup buttonGroup = this.buttonGroups.get(component);
        Defense.isInstanceOf((Object)component, JPanel.class);
        Defense.notNull((Object)buttonGroup);
        return this.createSubSectionToggleButton((JPanel)component, buttonGroup, action);
    }

    @Override
    public void removeElementFromSection(AbstractButton headerButton, AbstractButton elementButton) {
        JComponent component = this.completeSet.get(headerButton);
        ButtonGroup buttonGroup = this.buttonGroups.get(component);
        component.remove(elementButton);
        buttonGroup.remove(elementButton);
    }

    public void selectSection(FlipManager flippablePanel, ComponentRelation componentRelation) {
        JToggleButton button = this.getSection(componentRelation);
        if (button != null) {
            this.selectButton(button);
            button.getAction().actionPerformed(null);
            Object toSelect = componentRelation.getTargetObject();
            if (toSelect instanceof CardPanel) {
                CardPanel cardPanel = (CardPanel)toSelect;
                if (flippablePanel.canSwitchTo(cardPanel.getClass())) {
                    flippablePanel.switchTo(((CardPanel)toSelect).getClass());
                }
            } else if (toSelect instanceof Action) {
                ((Action)toSelect).actionPerformed(null);
            }
        }
    }

    private void selectButton(AbstractButton button) {
        ActionListener[] actionListenerArray = button.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(new ActionEvent(button, 0, null, 1001));
            ++n2;
        }
    }

    private JPanel createPanelOfToggleButtons(WidgetFactory factory, Action ... actions) {
        JPanel result = factory.verticalPanel(new JComponent[0]);
        ButtonGroup group = new ButtonGroup();
        for (Action each : ArrayUtils.filter((Object[])actions, Action.class)) {
            this.createSubSectionToggleButton(result, group, each);
        }
        this.buttonGroups.put(result, group);
        return result;
    }

    private AbstractButton createSubSectionToggleButton(JPanel result, ButtonGroup group, Action each) {
        each.putValue("Function", (Object)ActionDefinition.Function.SUB_SECTION_HEADER);
        JToggleButton button = this.decorateButton(this.factory.createToggleButton(each));
        if (this.completeSet.isEmpty() && group.getButtonCount() == 0) {
            button.setSelected(true);
        }
        result.add(button);
        group.add(button);
        return button;
    }

    public void setLanguage(LanguageConfiguration.SupportedLanguage language) {
        this.language = language;
    }

    protected <B extends AbstractButton> B decorateButton(B button) {
        if (this.language == null) {
            Log.error((String)"Language needs to be set on this component");
        }
        if (this.language != LanguageConfiguration.SupportedLanguage.en) {
            button.setFont(this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Size.MEDIUM));
        }
        button.setHorizontalTextPosition(2);
        button.setHorizontalAlignment(2);
        this.formatNameIfTooLong(button);
        return button;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void formatNameIfTooLong(AbstractButton button) {
        String name = button.getText();
        FontMetrics fontMetrics = button.getFontMetrics(button.getFont());
        if (fontMetrics.stringWidth(name) <= 120) return;
        String firstLine = "";
        String lastLine = "";
        boolean lineIsDivided = false;
        String divideBy = " ";
        if (!name.contains(divideBy)) {
            divideBy = "-";
        }
        if (!name.contains(divideBy)) {
            divideBy = "/";
        }
        String[] stringArray = StringUtils.split((String)divideBy, (String)name);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                String each;
                block14: {
                    each = stringArray[n2];
                    if (lineIsDivided) break block14;
                    if (fontMetrics.stringWidth(String.valueOf(firstLine) + divideBy + each) < 120) {
                        firstLine = String.valueOf(firstLine) + each + divideBy;
                        break block13;
                    } else if (!firstLine.isEmpty()) {
                        lineIsDivided = true;
                        firstLine = this.ellipsizeText(firstLine.trim(), fontMetrics);
                        lastLine = each;
                        break block13;
                    } else {
                        lineIsDivided = true;
                        firstLine = this.ellipsizeText(each.trim(), fontMetrics);
                    }
                    break block13;
                }
                if (lastLine.isEmpty()) {
                    if (fontMetrics.stringWidth(each) < 120) {
                        lastLine = each;
                        break block13;
                    } else {
                        lastLine = this.ellipsizeText(each, fontMetrics);
                        break;
                    }
                }
                if (fontMetrics.stringWidth(String.valueOf(lastLine) + divideBy + each) < 120) {
                    lastLine = String.valueOf(lastLine) + divideBy + each;
                } else {
                    lastLine = this.ellipsizeText(String.valueOf(lastLine) + divideBy + each, fontMetrics);
                    break;
                }
            }
            ++n2;
        }
        if (lineIsDivided && !lastLine.isEmpty()) {
            button.setText(HTML.html((String)HTML.indentLeft((int)27, (String)HTML.maxWidth((int)120, (String)(String.valueOf(firstLine) + HTML.br() + lastLine)))));
            button.setPreferredSize(new Dimension(180, 50));
            return;
        }
        button.setText(firstLine);
    }

    private String ellipsizeText(String text, FontMetrics fontMetrics) {
        while (fontMetrics.stringWidth(text) >= 120 && text.length() > 4) {
            text = String.valueOf(text.substring(0, text.length() - 4)) + "...";
        }
        return text;
    }

    private JToggleButton getSection(ComponentRelation componentRelation) {
        Enumeration<AbstractButton> sections = this.buttonGroup.getElements();
        while (sections.hasMoreElements()) {
            JToggleButton section = (JToggleButton)sections.nextElement();
            ActionListener[] actionListenerArray = section.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ShowSelectionMeWhenClicked showSelectionMeWhenClicked;
                Class<? extends CardPanel> panelType;
                ActionListener listener = actionListenerArray[n2];
                if (listener instanceof CollapseOthersAndShowMeWhenClicked) {
                    CollapseOthersAndShowMeWhenClicked collapseOthersAndShowMeWhenClicked = (CollapseOthersAndShowMeWhenClicked)listener;
                    JPanel container = (JPanel)collapseOthersAndShowMeWhenClicked.getComponent();
                    Component[] componentArray = container.getComponents();
                    int n3 = componentArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component component = componentArray[n4];
                        if (componentRelation.sameLeaf(component)) {
                            return section;
                        }
                        ++n4;
                    }
                } else if (listener instanceof ShowSelectionMeWhenClicked && (panelType = ((ShowScreenAction)(showSelectionMeWhenClicked = (ShowSelectionMeWhenClicked)((Object)listener)).action).getDestinationPanelType()).equals(componentRelation.getTargetObject())) {
                    return section;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void resetNavigation() {
        AbstractButton firstSectionButton = this.buttonGroup.getElements().nextElement();
        this.selectTopSection(firstSectionButton);
    }

    public void selectTopSection(AbstractButton section) {
        MouseEvent emulatedEvent = new MouseEvent(section, 501, System.currentTimeMillis(), 0, 0, 0, 1, false);
        MouseListener[] mouseListenerArray = section.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener each = mouseListenerArray[n2];
            each.mousePressed(emulatedEvent);
            ++n2;
        }
        section.doClick();
        section.getAction().actionPerformed(null);
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    public void fitSizeToButtons() {
        int iconAndPaddingWidth = 0;
        Dimension preferredDimensions = UIManager.getDimension("AccordionView.dimensions");
        int menuItemHeight = preferredDimensions.height;
        int maxWidth = preferredDimensions.width;
        Component[] componentArray = this.content.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component menuItem = componentArray[n2];
            if (iconAndPaddingWidth == 0 && menuItem instanceof JToggleButton) {
                JToggleButton jToggleButton = (JToggleButton)menuItem;
                iconAndPaddingWidth = jToggleButton.getIconTextGap() * 3 + jToggleButton.getHorizontalTextPosition() + jToggleButton.getIcon().getIconWidth() + jToggleButton.getMargin().left;
                menuItemHeight = menuItem.getPreferredSize().height;
            }
            String menuName = menuItem.getName();
            int stringWidth = menuItem.getFontMetrics(menuItem.getFont()).stringWidth(menuName);
            if (stringWidth + iconAndPaddingWidth > maxWidth) {
                maxWidth = stringWidth + iconAndPaddingWidth;
            }
            ++n2;
        }
        int contentHeight = menuItemHeight * this.content.getComponents().length + 20;
        this.content.setPreferredSize(new Dimension(maxWidth, contentHeight));
    }

    @Override
    public Action getSelected() {
        for (JComponent each : this.completeSet.values()) {
            if (each instanceof JPanel && each.isVisible()) {
                Component[] componentArray = each.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component eachSubComponent = componentArray[n2];
                    if (eachSubComponent.isVisible() && eachSubComponent instanceof AbstractButton && ((AbstractButton)eachSubComponent).isSelected()) {
                        return ((AbstractButton)eachSubComponent).getAction();
                    }
                    ++n2;
                }
            }
            if (!each.isVisible() || !(each instanceof AbstractButton) || !((AbstractButton)each).isSelected()) continue;
            return ((AbstractButton)each).getAction();
        }
        return null;
    }

    public List<AbstractButton> getTopSections() {
        ArrayList<AbstractButton> sections = new ArrayList<AbstractButton>();
        Enumeration<AbstractButton> sectionEnumeration = this.buttonGroup.getElements();
        while (sectionEnumeration.hasMoreElements()) {
            sections.add(sectionEnumeration.nextElement());
        }
        return Collections.unmodifiableList(sections);
    }

    public void addVetoOnAction(Veto vetoOnExit) {
        this.vetoList.add(vetoOnExit);
    }

    public static class CollapseOthersAndShowMeWhenClicked
    implements ActionListener {
        private final Action action;
        private final JComponent toShow;
        private final Map<AbstractButton, JComponent> completeSet;
        private final ButtonGroup buttonGroup;
        private final List<Veto> vetoList;

        CollapseOthersAndShowMeWhenClicked(Action action, JComponent toShow, Map<AbstractButton, JComponent> completeSet, ButtonGroup buttonGroup, List<Veto> vetoList) {
            this.action = action;
            this.toShow = toShow;
            this.completeSet = completeSet;
            this.buttonGroup = buttonGroup;
            this.vetoList = vetoList;
        }

        public JComponent getComponent() {
            return this.toShow;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.toShow.isVisible() && this.isAllowedToExecuteAction()) {
                for (JComponent each : this.completeSet.values()) {
                    each.setVisible(false);
                }
                for (JComponent each : new IterableEnumerationWrapper(this.buttonGroup.getElements())) {
                    ((AbstractButton)each).getAction().putValue("SmallIcon", ImageResource.menuCollapse());
                }
                this.toShow.setVisible(true);
                this.action.putValue("SwingSelectedKey", true);
                this.action.putValue("SmallIcon", ImageResource.menuExpand());
            }
        }

        private boolean isAllowedToExecuteAction() {
            return this.vetoList.stream().noneMatch(Veto::isVetoed);
        }
    }

    public static interface ComponentRelation {
        public Object getTargetObject();

        public boolean sameLeaf(Component var1);
    }

    public static class ShowSelectionMeWhenClicked
    implements ItemListener {
        private final Action action;
        private final ButtonGroup buttonGroup;

        ShowSelectionMeWhenClicked(Action action, ButtonGroup buttonGroup) {
            this.action = action;
            this.buttonGroup = buttonGroup;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            for (AbstractButton each : new IterableEnumerationWrapper(this.buttonGroup.getElements())) {
                each.getAction().putValue("SmallIcon", ImageResource.navigationItemUnselected());
            }
            this.action.putValue("SwingSelectedKey", true);
            this.action.putValue("SmallIcon", ImageResource.navigationItemSelected());
        }
    }
}

