/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.baseview;

import com.ur.swing.BaseView;
import com.ur.swing.GuiUtilities;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.PostTreeCellRenderer;
import com.ur.swing.extensible.TreeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;

public class BaseTreeView
extends BaseView
implements TreeView {
    public static final String SCROLL_PANE_NAME = "BaseTreeView.scrollPane";
    private final ContributableTreeCellRenderer rendererSite = new ContributableTreeCellRenderer();
    private JTree tree;
    private JScrollPane scrollPane;

    public BaseTreeView(WidgetFactory factory) {
        this.setLayout(new BorderLayout());
        if (factory == null) {
            this.setContent(new JTree());
        } else {
            this.setContent(factory.createTree());
        }
    }

    @Override
    public void setContent(JComponent tree) {
        this.tree = (JTree)tree;
        this.tree.setCellRenderer(this.rendererSite);
        this.tree.setBackground(this.getBackground());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBackground(this.getBackground());
        this.scrollPane.setOpaque(false);
        this.scrollPane.setViewportView(tree);
        this.scrollPane.setName(SCROLL_PANE_NAME);
        GuiUtilities.setScrollbarWidthLarge(this.scrollPane);
        super.setContent(this.scrollPane);
    }

    @Override
    public JViewport getViewport() {
        return this.scrollPane.getViewport();
    }

    @Override
    public void setTreeCellRenderer(TreeCellRenderer renderer) {
        this.rendererSite.setCoreRenderer(renderer);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.tree.getSelectionModel();
    }

    @Override
    public void appendPostTreeCellRenderer(PostTreeCellRenderer renderer) {
        this.rendererSite.appendPostRenderer(renderer);
    }

    public JTree getTree() {
        return this.tree;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.tree != null) {
            this.tree.setBackground(bg);
        }
    }

    public static class ContributableTreeCellRenderer
    implements TreeCellRenderer {
        private final List<PostTreeCellRenderer> postRenderers;
        private TreeCellRenderer coreRenderer = new DefaultTreeCellRenderer();

        public ContributableTreeCellRenderer() {
            this.postRenderers = new ArrayList<PostTreeCellRenderer>();
        }

        public void setCoreRenderer(TreeCellRenderer renderer) {
            this.coreRenderer = renderer;
        }

        public void appendPostRenderer(PostTreeCellRenderer renderer) {
            this.postRenderers.add(renderer);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = this.coreRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            for (PostTreeCellRenderer each : this.postRenderers) {
                result = each.getTreeCellRendererComponent(result, tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return result;
        }
    }
}

