/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.card;

import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.internal.i18n.Translations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class NavigateBackWrapper
extends CardPanel {
    private static Translations textResource;
    private CardPanel wrappedCardPanel;

    public NavigateBackWrapper(CardPanel wrappedCardPanel, JComponent ... controllsToAdd) {
        this.wrappedCardPanel = wrappedCardPanel;
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.add((Component)wrappedCardPanel, "Center");
        this.add((Component)this.createBottomDashBoard(controllsToAdd), "South");
    }

    @Inject
    public static void setTranslations(Translations textResource) {
        NavigateBackWrapper.textResource = textResource;
    }

    @Override
    public void setFlipManager(FlipManager flipManager) {
        super.setFlipManager(flipManager);
        this.wrappedCardPanel.setFlipManager(flipManager);
    }

    private JPanel createBottomDashBoard(JComponent ... controllsToAdd) {
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout(2));
        JComponent[] jComponentArray = controllsToAdd;
        int n = controllsToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent each = jComponentArray[n2];
            result.add((Component)each, "South");
            ++n2;
        }
        result.add(this.createExitButton());
        return result;
    }

    private JButton createExitButton() {
        JButton navigateBack = new JButton();
        navigateBack.setText(textResource.exit());
        navigateBack.addActionListener(new NavigateBackOnClick());
        return navigateBack;
    }

    @Override
    public void enter(Object o) {
        this.wrappedCardPanel.enter(o);
    }

    @Override
    public Object exit() {
        return this.wrappedCardPanel.exit();
    }

    @Override
    public String toString() {
        String s = super.toString();
        if (this.wrappedCardPanel != null) {
            s = String.valueOf(s) + " wrapping " + this.wrappedCardPanel.getName();
        }
        return s;
    }

    private final class NavigateBackOnClick
    implements ActionListener {
        private NavigateBackOnClick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigateBackWrapper.this.flipManager.navigateBack();
        }
    }
}

