/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.lang.Defense;
import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogRunnable;
import com.ur.swing.dialog.DialogTask;
import com.ur.swing.dialog.DialogTaskComparator;
import com.ur.swing.dialog.PriorityExecutor;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DialogExecutor {
    private static int counter = 0;
    private final FutureStore futures = new FutureStore();
    private final ExecutorService executor = new PriorityExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread result = Executors.defaultThreadFactory().newThread(runnable);
            StringBuilder stringBuilder = new StringBuilder("DialogExecutor-");
            int n = counter + 1;
            counter = n;
            result.setName(stringBuilder.append(n).toString());
            result.setDaemon(true);
            return result;
        }
    });
    private final ExecuteWhen executeWhen;
    private final int maxQueueSize;

    public DialogExecutor(ExecuteWhen conditionWhenRunning, int maxQueueSize) {
        Defense.notNull((Object)conditionWhenRunning, (String)"ExecuteWhen cannot be null");
        this.executeWhen = conditionWhenRunning;
        this.maxQueueSize = maxQueueSize;
    }

    public int itemsEnqueued() {
        return this.futures.futureCount();
    }

    public boolean isEmpty() {
        return this.futures.futureCount() == 0;
    }

    public void clearQueue() {
        this.futures.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DialogTask<T> execute(DialogRunnable<T> dialogRunnable) {
        DialogTask<T> dialogTask;
        FutureStore futureStore = this.futures;
        synchronized (futureStore) {
            dialogTask = this.queueRunnable(dialogRunnable);
        }
        return dialogTask;
    }

    private <T> DialogTask<T> queueRunnable(DialogRunnable<T> dialogRunnable) {
        DialogTask<T> dialogTask = new DialogTask<T>(dialogRunnable);
        if (!this.futures.contains(dialogTask) && this.futures.futureCount() < this.maxQueueSize) {
            Future<?> future = this.executor.submit(new WaitForConditionAndRunTask<T>(new WaitForConditionAndRun<T>(dialogTask)));
            this.futures.register(dialogTask, future);
            dialogTask.setAccepted();
            return dialogTask;
        }
        dialogTask.setNotAcceptedAndNotify();
        if (this.futures.futureCount() >= this.maxQueueSize) {
            Log.warning((String)("Dialog not accepted as queue full : size = " + this.futures.futureCount()));
        }
        this.onNotAccepted(dialogTask);
        return dialogTask;
    }

    public <T> void onNotAccepted(DialogTask<T> dialogTask) {
    }

    public static interface ExecuteWhen {
        public boolean canExecute();
    }

    private static class FutureStore<T> {
        private final Map<DialogTask<T>, Future<?>> futures = new ConcurrentHashMap();

        private FutureStore() {
        }

        void register(DialogTask<T> dialogTask, Future<?> future) {
            this.removeDoneFutures();
            this.futures.put(dialogTask, future);
        }

        boolean contains(DialogTask<T> dialogTask) {
            this.removeDoneFutures();
            return this.futures.keySet().contains(dialogTask);
        }

        int futureCount() {
            this.removeDoneFutures();
            return this.futures.size();
        }

        void cancel() {
            this.removeDoneFutures();
            for (Map.Entry<DialogTask<T>, Future<?>> each : this.futures.entrySet()) {
                DialogTask<T> dialogTask = each.getKey();
                Future<?> future = each.getValue();
                future.cancel(false);
                dialogTask.cancel(false);
            }
        }

        private void removeDoneFutures() {
            Iterator<Map.Entry<DialogTask<T>, Future<?>>> iterator = this.futures.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().isDone()) continue;
                iterator.remove();
            }
        }
    }

    private class WaitForConditionAndRun<T>
    implements Runnable {
        private final DialogTask<T> task;

        WaitForConditionAndRun(DialogTask<T> task) {
            this.task = task;
        }

        @Override
        public void run() {
            while (!this.canExecute()) {
                Waiting.pause((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            SwingUtil.invokeAndWait(this.task);
        }

        private boolean canExecute() {
            final AtomicBoolean canExecute = new AtomicBoolean(false);
            SwingUtil.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    canExecute.set(DialogExecutor.this.executeWhen.canExecute());
                }
            });
            return canExecute.get();
        }

        DialogTask<T> getDialogTask() {
            return this.task;
        }
    }

    private static class WaitForConditionAndRunTask<T>
    extends FutureTask<T>
    implements Comparable<WaitForConditionAndRunTask<T>> {
        private final DialogTaskComparator dialogTaskComparator = new DialogTaskComparator();
        private final DialogTask<T> task;

        WaitForConditionAndRunTask(WaitForConditionAndRun<T> runnableTask) {
            super(runnableTask, null);
            this.task = runnableTask.getDialogTask();
        }

        @Override
        public int compareTo(WaitForConditionAndRunTask<T> o) {
            return this.dialogTaskComparator.compare(this.task, o.task);
        }
    }
}

