/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.JFrameUtils;
import com.ur.swing.ScreenUtils;
import com.ur.util.Optional;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class DialogPositionUtils {
    public static PositionRelativeToAnchor setDialogLocationCloseToAnchor(JDialog dialog, JComponent anchor) {
        Optional<JFrame> parentFrame = JFrameUtils.getParentFrame();
        if (!parentFrame.isPresent()) {
            return PositionRelativeToAnchor.NONE;
        }
        Rectangle screenBounds = ScreenUtils.getScreenBounds();
        DialogPosition position = DialogPositionUtils.setDialogAtPreferedPosition(dialog, anchor, screenBounds);
        if (position.isPositionSet()) {
            return position.getPositionRelativeToAnchor();
        }
        position = DialogPositionUtils.setPositionNextToAnchor(dialog, anchor, screenBounds);
        if (!position.isPositionSet()) {
            dialog.setLocationRelativeTo((Component)parentFrame.get());
            return PositionRelativeToAnchor.CENTER;
        }
        return position.getPositionRelativeToAnchor();
    }

    public static boolean isAboveAnchor(PositionRelativeToAnchor pos) {
        return pos == PositionRelativeToAnchor.NORTH_EAST || pos == PositionRelativeToAnchor.NORTH_WEST;
    }

    private static DialogPosition setDialogAtPreferedPosition(JDialog dialog, JComponent anchor, Rectangle screenBounds) {
        List<DialogPosition> candidates = DialogPositionUtils.createDialogPositionCandidates(dialog, anchor);
        for (DialogPosition position : candidates) {
            if (!DialogPositionUtils.canDialogBePlacedAtPoint(dialog, position.getPoint(), screenBounds)) continue;
            dialog.setLocation(position.getPoint());
            return position;
        }
        return new DialogPosition();
    }

    private static List<DialogPosition> createDialogPositionCandidates(JDialog dialog, JComponent anchor) {
        ArrayList<DialogPosition> candidates = new ArrayList<DialogPosition>();
        candidates.add(new DialogPosition(PositionRelativeToAnchor.SOUTH_EAST, DialogPositionUtils.translate(anchor.getLocationOnScreen(), 0, anchor.getHeight())));
        candidates.add(new DialogPosition(PositionRelativeToAnchor.NORTH_EAST, DialogPositionUtils.translate(anchor.getLocationOnScreen(), 0, -dialog.getHeight())));
        candidates.add(new DialogPosition(PositionRelativeToAnchor.SOUTH_WEST, DialogPositionUtils.translate(anchor.getLocationOnScreen(), -(dialog.getWidth() - anchor.getWidth()), anchor.getHeight())));
        candidates.add(new DialogPosition(PositionRelativeToAnchor.NORTH_WEST, DialogPositionUtils.translate(anchor.getLocationOnScreen(), -(dialog.getWidth() - anchor.getWidth()), -dialog.getHeight())));
        return candidates;
    }

    private static boolean canDialogBePlacedAtPoint(JDialog dialog, Point p, Rectangle frameBounds) {
        Rectangle dialogBounds = dialog.getBounds();
        dialogBounds.setLocation(p);
        return frameBounds.contains(dialogBounds);
    }

    private static DialogPosition setPositionNextToAnchor(JDialog dialog, JComponent anchor, Rectangle frameBounds) {
        PositionRelativeToAnchor direction;
        int dialogX;
        Point anchorPoint = anchor.getLocationOnScreen();
        int distanceFromAnchorToFrameBottom = frameBounds.height - (anchorPoint.y - frameBounds.y);
        int dialogExtraSpace = distanceFromAnchorToFrameBottom - dialog.getHeight();
        int dialogY = dialogExtraSpace >= 0 ? anchorPoint.y : anchorPoint.y - dialogExtraSpace;
        int anchorRightPosition = anchorPoint.x + anchor.getWidth();
        int frameRightPosition = frameBounds.x + (int)frameBounds.getWidth();
        if (anchorRightPosition + dialog.getWidth() > frameRightPosition) {
            dialogX = anchorPoint.x - dialog.getWidth();
            direction = PositionRelativeToAnchor.WEST;
        } else {
            dialogX = anchorRightPosition;
            direction = PositionRelativeToAnchor.EAST;
        }
        Point point = new Point(dialogX, dialogY);
        if (DialogPositionUtils.canDialogBePlacedAtPoint(dialog, point, frameBounds)) {
            dialog.setLocation(point);
            return new DialogPosition(direction, point);
        }
        return new DialogPosition();
    }

    private static Point translate(Point p, int dx, int dy) {
        p.translate(dx, dy);
        return p;
    }

    private static class DialogPosition {
        private Point point;
        private PositionRelativeToAnchor positionRelativeToAnchor;

        public DialogPosition(PositionRelativeToAnchor positionRelativeToAnchor, Point point) {
            this.point = point;
            this.positionRelativeToAnchor = positionRelativeToAnchor;
        }

        public DialogPosition() {
            this.point = null;
            this.positionRelativeToAnchor = PositionRelativeToAnchor.NONE;
        }

        public Point getPoint() {
            return this.point;
        }

        public PositionRelativeToAnchor getPositionRelativeToAnchor() {
            return this.positionRelativeToAnchor;
        }

        public boolean isPositionSet() {
            return this.positionRelativeToAnchor != PositionRelativeToAnchor.NONE;
        }
    }

    public static enum PositionRelativeToAnchor {
        SOUTH_EAST,
        NORTH_EAST,
        SOUTH_WEST,
        NORTH_WEST,
        EAST,
        WEST,
        CENTER,
        NONE;

    }
}

