/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.dialog.DialogProviderCallback;
import com.ur.swing.dialog.URDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

@Singleton
public class DialogProvider
implements Provider<JDialog> {
    private static final Integer TIMER_DELAY = 5000;
    private static final JDialog CLEAN_DIALOG = new JDialog();
    private final Provider<JFrame> jFrameProvider;
    private List<JDialog> dialogCache = Collections.synchronizedList(new ArrayList());
    private List<JDialog> toBeCachedDialogs = Collections.synchronizedList(new ArrayList());
    private DialogProviderCallback callback = this.createCallback();

    @Inject
    public DialogProvider(Provider<JFrame> jFrameProvider) {
        this.jFrameProvider = jFrameProvider;
    }

    public JDialog get() {
        return this.getReusableDialog();
    }

    private synchronized JDialog getReusableDialog() {
        if (this.dialogCache.isEmpty()) {
            return new URDialog((Frame)this.jFrameProvider.get(), this.callback);
        }
        return this.dialogCache.remove(0);
    }

    private DialogProviderCallback createCallback() {
        return new DialogProviderCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cache(URDialog dialog) {
                List list = DialogProvider.this.toBeCachedDialogs;
                synchronized (list) {
                    if (DialogProvider.this.toBeCachedDialogs.contains(dialog) || DialogProvider.this.dialogCache.contains(dialog)) {
                        return;
                    }
                    DialogProvider.this.toBeCachedDialogs.add(dialog);
                }
                DialogProvider.this.cleanUpAndReuseLater(dialog);
            }
        };
    }

    private void cleanUpAndReuseLater(final URDialog dialog) {
        Timer delayedCleanupTimer = new Timer(TIMER_DELAY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogProvider.this.cleanUp(dialog);
                DialogProvider.this.putBackIntoCache(dialog);
            }
        });
        delayedCleanupTimer.setRepeats(false);
        delayedCleanupTimer.start();
    }

    private void cleanUp(URDialog dialog) {
        if (dialog.getParent() != null) {
            dialog.getParent().remove(dialog);
        }
        this.removeToolTip(dialog);
        dialog.getContentPane().removeAll();
        this.resetProperties(dialog);
    }

    private void removeToolTip(Container parent) {
        Component[] componentArray = parent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JComponent) {
                ((JComponent)c).setToolTipText(null);
            }
            if (c instanceof Container) {
                this.removeToolTip((Container)c);
            }
            ++n2;
        }
    }

    private void resetProperties(URDialog dialog) {
        dialog.setModal(CLEAN_DIALOG.isModal());
        dialog.setDefaultCloseOperation(CLEAN_DIALOG.getDefaultCloseOperation());
        dialog.setResizable(CLEAN_DIALOG.isResizable());
        dialog.getRootPane().setBorder(CLEAN_DIALOG.getRootPane().getBorder());
        dialog.getRootPane().setWindowDecorationStyle(CLEAN_DIALOG.getRootPane().getWindowDecorationStyle());
        dialog.setBackground(CLEAN_DIALOG.getBackground());
        ((JPanel)dialog.getContentPane()).setBorder(((JPanel)CLEAN_DIALOG.getContentPane()).getBorder());
        ((JPanel)dialog.getContentPane()).setOpaque(CLEAN_DIALOG.getContentPane().isOpaque());
        dialog.setAsNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBackIntoCache(JDialog dialog) {
        List<JDialog> list = this.toBeCachedDialogs;
        synchronized (list) {
            this.toBeCachedDialogs.remove(dialog);
            this.dialogCache.add(dialog);
        }
    }
}

