/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.dialog.DialogButtonListener;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.URDialogPanel;
import java.util.concurrent.Callable;

public abstract class DialogRunnable<V>
implements Callable<V> {
    private DialogMessage dialogMessage;
    private URDialogPanel panel;
    private V defaultValue;
    private DialogButtonListener dialogButtonListener;
    private Callback<V> callback = new Callback<V>(){

        @Override
        public void setReturnValueAndClose(V returnValue) {
        }

        @Override
        public void close() {
        }
    };

    public DialogRunnable(DialogMessage dialogMessage, URDialogPanel panel, V defaultValue, DialogButtonListener dialogButtonListener) {
        this.dialogMessage = dialogMessage;
        this.panel = panel;
        this.defaultValue = defaultValue;
        this.dialogButtonListener = dialogButtonListener;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public DialogMessage getDialogMessage() {
        return this.dialogMessage;
    }

    public URDialogPanel getPanel() {
        return this.panel;
    }

    public DialogButtonListener<V> getDialogButtonListener() {
        return this.dialogButtonListener;
    }

    @Override
    public V call() throws Exception {
        this.run(this);
        return null;
    }

    public abstract void run(DialogRunnable<V> var1);

    public void setReturnValueAndClose(V returnValue) {
        this.callback.setReturnValueAndClose(returnValue);
    }

    void setCallback(Callback<V> callback) {
        this.callback = callback;
    }

    public void close() {
        this.callback.close();
    }

    public static interface Callback<V> {
        public void setReturnValueAndClose(V var1);

        public void close();
    }
}

