/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogButtonListener;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogPriority;
import com.ur.swing.dialog.DialogRunnable;
import com.ur.swing.dialog.SwingWaiting;
import com.ur.util.logging.Log;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DialogTask<V>
extends FutureTask<V> {
    private DialogMessage dialogMessage;
    private DialogButtonListener<V> dialogButtonListener;
    private boolean isAccepted;
    private Date creationDate = new Date();
    private V returnValue;

    public DialogTask(DialogRunnable<V> dialogRunnable) {
        super(dialogRunnable);
        this.dialogMessage = dialogRunnable.getDialogMessage();
        this.returnValue = dialogRunnable.getDefaultValue();
        this.dialogButtonListener = dialogRunnable.getDialogButtonListener();
        this.isAccepted = false;
        dialogRunnable.setCallback(new DialogRunnable.Callback<V>(){

            @Override
            public void setReturnValueAndClose(V returnValue) {
                DialogTask.this.returnValue = returnValue;
                DialogTask.this.cancel(false);
                DialogButtonListener listener = DialogTask.this.dialogButtonListener;
                SwingUtil.invokeLater(() -> listener.onClick(returnValue));
                DialogTask.this.removedOnClickListener();
            }

            @Override
            public void close() {
                DialogTask.this.cancel(false);
                DialogTask.this.removedOnClickListener();
            }
        });
    }

    private void removedOnClickListener() {
        this.dialogButtonListener = new DialogButtonListener<V>(){

            @Override
            public void onClick(V returnValue) {
            }
        };
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DialogTask)) {
            return false;
        }
        DialogTask other = (DialogTask)obj;
        return new EqualsBuilder().append(this.dialogMessage.getId(), other.dialogMessage.getId()).append(this.dialogMessage.getPriority().ordinal(), other.dialogMessage.getPriority().ordinal()).append((Object)this.dialogMessage.getTitle(), (Object)other.dialogMessage.getTitle()).append((Object)this.dialogMessage.getMessage(), (Object)other.dialogMessage.getMessage()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.dialogMessage.getId()).append(this.dialogMessage.getPriority().ordinal()).append((Object)this.dialogMessage.getTitle()).append((Object)this.dialogMessage.getMessage()).toHashCode();
    }

    @Override
    public void run() {
        this.isAccepted = true;
        super.run();
    }

    public V getReturnValue() {
        if (!this.isAccepted) {
            return this.returnValue;
        }
        if (SwingUtil.isUiOrEventThread()) {
            SwingWaiting.until(() -> {
                this.waitForResult();
                return true;
            }, 30, TimeUnit.DAYS);
        } else {
            this.waitForResult();
        }
        return this.returnValue;
    }

    private void waitForResult() {
        try {
            this.get();
        }
        catch (CancellationException ce) {
            Log.info((String)ce.getMessage());
        }
        catch (InterruptedException ie) {
            Log.info((String)ie.getMessage());
        }
        catch (Throwable t) {
            Log.error((String)t.getMessage());
        }
    }

    void setAccepted() {
        this.isAccepted = true;
    }

    void setNotAcceptedAndNotify() {
        this.isAccepted = false;
        this.dialogButtonListener.onRejected();
    }

    DialogPriority getPriority() {
        return this.dialogMessage.getPriority();
    }

    Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String toString() {
        return String.valueOf(this.dialogMessage.getTitle()) + " (" + this.hashCode() + ")";
    }
}

