/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.dialog.HiddenLegacyDialog;
import com.ur.util.logging.Log;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.JDialog;

public class SwingWaitDialogFactory {
    private static int MAX_POOL_SIZE = 25;
    private static LinkedBlockingDeque<JDialog> dialogCache = new LinkedBlockingDeque(MAX_POOL_SIZE);

    public static JDialog getFromCacheOrCreate() {
        JDialog waitDialog = dialogCache.poll();
        return waitDialog == null ? HiddenLegacyDialog.getInstance() : waitDialog;
    }

    public static synchronized void pushOntoCache(JDialog waitDialog) {
        if (dialogCache.size() > MAX_POOL_SIZE) {
            Log.warning((String)("More than " + MAX_POOL_SIZE + " wait dialogs!"));
        } else {
            dialogCache.push(waitDialog);
        }
    }
}

