/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.SwingWaitDialogFactory;
import com.ur.util.Waiting;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;

public class SwingWaiting {
    private static final ExecutorService threadPoolExecutor = Executors.newCachedThreadPool();

    public static void until(final Waiting.ItHappens itHappens, final int timeout, final TimeUnit unit) {
        SwingUtil.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SwingWaiting.waitUntilOnUIThread(itHappens, timeout, unit);
            }
        });
    }

    private static void waitUntilOnUIThread(final Waiting.ItHappens itHappens, final long timeout, final TimeUnit unit) {
        final JDialog waitDialog = SwingWaitDialogFactory.getFromCacheOrCreate();
        threadPoolExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Waiting.until((Waiting.ItHappens)itHappens, (int)((int)timeout), (TimeUnit)unit);
                if (!waitDialog.isVisible()) {
                    Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                        public boolean itHappened() {
                            return waitDialog.isVisible();
                        }
                    }, (int)30, (TimeUnit)TimeUnit.SECONDS);
                }
                SwingUtil.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        waitDialog.setVisible(false);
                        SwingWaitDialogFactory.pushOntoCache(waitDialog);
                    }
                });
            }
        });
        waitDialog.setVisible(true);
    }
}

