/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogProviderCallback;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;

public class URDialog
extends JDialog {
    private DialogProviderCallback callback;
    private AtomicBoolean isNew = new AtomicBoolean(false);
    private AtomicBoolean isDisposable = new AtomicBoolean(true);

    public URDialog(Frame owner, DialogProviderCallback callback) {
        super(owner);
        this.callback = callback;
    }

    private void postOpenWindowEvent() {
        if (this.isNew.getAndSet(false)) {
            WindowEvent e = new WindowEvent(this, 200);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
        }
    }

    @Override
    public void dispose() {
        if (!this.isNew.get() && this.isDisposable.getAndSet(false)) {
            try {
                this.callback.cache(this);
            }
            finally {
                if (this.isDisplayable()) {
                    WindowEvent e = new WindowEvent(this, 202);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                }
                this.setVisible(false);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.validate();
            this.repaint();
            SwingUtil.invokeLater(this::postOpenWindowEvent);
        }
        super.setVisible(visible);
    }

    void setAsNew() {
        this.isNew.set(true);
        this.isDisposable.set(true);
    }
}

