/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.dialog;

import com.ur.swing.SwingUtil;
import com.ur.swing.dialog.DialogRunnable;
import com.ur.swing.dialog.URDialogType;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public abstract class URDialogPanel
extends JPanel {
    private DialogRunnable dialogRunnable = this.createEmptyDialogRunnable();

    public abstract JPanel getPanel();

    public abstract URDialogType getDialogType();

    protected void resizeAndRepositionParentWindow() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window == null) {
            return;
        }
        window.pack();
        Dimension newSize = window.getPreferredSize();
        window.setLocationRelativeTo(window.getOwner());
        window.setBounds(window.getX(), window.getY(), newSize.width, newSize.height);
    }

    public <V> void setDialogRunnable(DialogRunnable<V> dialogRunnable) {
        this.dialogRunnable = dialogRunnable;
    }

    public <V> void setReturnValueAndClose(V returnValue) {
        this.disposeDialog(this.getParentDialog());
        this.dialogRunnable.setReturnValueAndClose(returnValue);
        this.dialogRunnable = this.createEmptyDialogRunnable();
    }

    private void disposeDialog(final JDialog dialog) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (dialog != null) {
                    dialog.dispose();
                }
            }
        });
    }

    private JDialog getParentDialog() {
        Container parentWindow;
        JRootPane rootPane = this.getPanel().getRootPane();
        Container container = parentWindow = rootPane != null ? rootPane.getParent() : null;
        if (parentWindow instanceof JDialog) {
            return (JDialog)parentWindow;
        }
        return null;
    }

    private DialogRunnable createEmptyDialogRunnable() {
        return new DialogRunnable(null, null, null, null){

            public void run(DialogRunnable dialogRunnable) {
            }
        };
    }
}

