/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression;

import com.ur.lang.EqualsUtil;
import com.ur.swing.expression.ExpressionCharNode;
import com.ur.swing.expression.ExpressionLeafNode;
import com.ur.swing.expression.ExpressionNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.inject.Inject;

public class ExpressionBranchNode
extends ExpressionNode
implements Iterable<ExpressionNode> {
    private Vector<ExpressionNode> exprNodes = new Vector();

    @Inject
    public ExpressionBranchNode() {
    }

    public ExpressionBranchNode(String s) {
        int i = 0;
        while (i < s.length()) {
            this.exprNodes.add(new ExpressionCharNode(s.charAt(i)));
            ++i;
        }
    }

    @Override
    public Iterator<ExpressionNode> iterator() {
        return this.exprNodes.iterator();
    }

    public void add(ExpressionNode node) {
        this.exprNodes.add(node);
    }

    public void addAll(Collection<ExpressionNode> nodes) {
        this.exprNodes.addAll(nodes);
    }

    @Override
    public ExpressionBranchNode clone() {
        ExpressionBranchNode clone = new ExpressionBranchNode();
        clone.exprNodes = new Vector();
        int i = 0;
        while (i < this.exprNodes.size()) {
            clone.exprNodes.add(this.exprNodes.get(i).clone());
            ++i;
        }
        return clone;
    }

    public ExpressionLeafNode getLeafNodeStartingAt(int startpos) {
        int pos = 0;
        for (ExpressionNode en : this.exprNodes) {
            if (en instanceof ExpressionBranchNode) {
                int length = en.getLength();
                if (pos + length > startpos) {
                    return ((ExpressionBranchNode)en).getLeafNodeStartingAt(startpos - pos);
                }
                pos += length;
                continue;
            }
            if (!(en instanceof ExpressionLeafNode)) continue;
            if (pos >= startpos) {
                return (ExpressionLeafNode)en;
            }
            pos += en.getLength();
        }
        return null;
    }

    public ExpressionNode.TextRange getRangeForLeafNodeEndingAt(int endpos) {
        int pos = 0;
        ExpressionNode.TextRange tr = new ExpressionNode.TextRange();
        for (ExpressionNode en : this.exprNodes) {
            int length = en.getLength();
            if (en instanceof ExpressionBranchNode) {
                if (pos + length > endpos) {
                    return ((ExpressionBranchNode)en).getRangeForLeafNodeEndingAt(endpos - pos);
                }
                pos += length;
                continue;
            }
            if (!(en instanceof ExpressionLeafNode)) continue;
            if (pos + length >= endpos) {
                tr.t_start = pos;
                tr.t_end = pos + length;
                return tr;
            }
            pos += en.getLength();
        }
        return null;
    }

    @Override
    public int getLength() {
        int length = 0;
        for (ExpressionNode en : this.exprNodes) {
            length += en.getLength();
        }
        return length;
    }

    public void clear() {
        this.exprNodes.removeAllElements();
    }

    public void removeRange(int start, int end) {
        int pos = 0;
        int i = 0;
        while (i < this.exprNodes.size()) {
            if ((pos += this.exprNodes.get(i).getLength()) > start && pos <= end) {
                this.exprNodes.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public void generateText(StringBuffer s) {
        for (ExpressionNode en : this.exprNodes) {
            en.generateText(s);
        }
    }

    @Override
    public String generateScriptCode() {
        StringBuilder result = new StringBuilder();
        for (ExpressionNode en : this.exprNodes) {
            result.append(en.generateScriptCode());
        }
        return result.toString();
    }

    public void insertElementAt(ExpressionNode nodeToInsert, int position) {
        int i = 0;
        while (i < this.exprNodes.size()) {
            if ((position -= this.exprNodes.get(i).getLength()) < 0) {
                this.exprNodes.insertElementAt(nodeToInsert, i);
                return;
            }
            ++i;
        }
        this.exprNodes.add(nodeToInsert);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Exp: ");
        this.generateText(s);
        return s.toString();
    }

    @Override
    public void getProgramEntities(Collection<Object> collection) {
        for (ExpressionNode node : this.exprNodes) {
            node.getProgramEntities(collection);
        }
    }

    @Override
    public boolean substituteReference(Object original, Object substitute) {
        boolean result = false;
        for (ExpressionNode node : this.exprNodes) {
            result |= node.substituteReference(original, substitute);
        }
        return result;
    }

    public void replaceNode(ExpressionNode original, ExpressionNode substitute) {
        int index = this.exprNodes.indexOf(original);
        this.exprNodes.remove(index);
        this.exprNodes.insertElementAt(substitute, index);
    }

    @Override
    public boolean isUndefined() {
        if (this.exprNodes.isEmpty()) {
            return true;
        }
        for (ExpressionNode node : this.exprNodes) {
            if (!node.isUndefined()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof ExpressionBranchNode) {
            ExpressionBranchNode other = (ExpressionBranchNode)o;
            return EqualsUtil.equals(this.exprNodes, other.exprNodes);
        }
        return false;
    }

    public int hashCode() {
        return this.exprNodes == null ? 0 : this.exprNodes.hashCode();
    }
}

