/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression;

import com.ur.swing.expression.ExpressionLeafNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;

public class ExpressionCharNode
extends ExpressionLeafNode {
    private static final Map<Character, String> SPECIAL_CHARACTER_SCRIPT_CODE = Collections.unmodifiableMap(new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('\u2260'), " != ");
            this.put(Character.valueOf('\u2264'), " <= ");
            this.put(Character.valueOf('\u2265'), " >= ");
            this.put(Character.valueOf('\u225f'), " == ");
        }
    });
    private char c;

    @Inject
    private ExpressionCharNode() {
    }

    public ExpressionCharNode(char c) {
        this.c = c;
    }

    public char getCharacter() {
        return this.c;
    }

    @Override
    public ExpressionCharNode clone() {
        return new ExpressionCharNode(this.c);
    }

    @Override
    public void generateText(StringBuffer s) {
        s.append(this.c);
    }

    @Override
    public String generateScriptCode() {
        String scriptCode = SPECIAL_CHARACTER_SCRIPT_CODE.get(Character.valueOf(this.c));
        return scriptCode == null ? "" + this.c : scriptCode;
    }

    @Override
    public int getLength() {
        return 1;
    }

    public String toString() {
        return "ExpCharNode:'" + this.c + "'";
    }

    public boolean equals(Object o) {
        if (o instanceof ExpressionCharNode) {
            ExpressionCharNode other = (ExpressionCharNode)o;
            return this.c == other.c;
        }
        return false;
    }

    public int hashCode() {
        return this.c;
    }
}

