/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.ExpressionCharNode;
import com.ur.swing.expression.ExpressionLeafNode;
import com.ur.swing.expression.ExpressionNode;
import com.ur.swing.text.BackspaceSupport;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.Keymap;

public class ExpressionEditorJTextField
extends JTextField
implements BackspaceSupport {
    private static final Color WARNING_COLOR = UIManager.getColor("undefined.warning");
    private static final Border ENABLED_NORMAL_BORDER = UIManager.getBorder("ExpressionTextField.enabledBorder");
    private static final Border DISABLED_NORMAL_BORDER = UIManager.getBorder("ExpressionTextField.disabledBorder");
    private static Border warningBorder = ExpressionEditorJTextField.createWarningBorder();
    private static Font warningFont;
    private static Font normalFont;
    private ExpressionBranchNode expression = new ExpressionBranchNode();

    @Inject
    public ExpressionEditorJTextField() {
        this.updateInputTextField();
        this.setForeground(Color.BLACK);
        this.setKeymap(new ExpressionKeyMap());
        this.addKeyListener(new FunctionKeyAdapter());
    }

    public void setExpression(ExpressionBranchNode e) {
        this.expression = e;
        this.updateInputTextField();
    }

    public ExpressionBranchNode getExpression() {
        return this.expression;
    }

    @Override
    public void replaceSelection(String content) {
        this.insertText(content);
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
        Log.trace((String)"Pasting");
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.insertText(text);
            }
        }
        catch (UnsupportedFlavorException e) {
            Log.warning((String)"Was not a string", (Throwable)e);
        }
        catch (IOException e) {
            Log.warning((String)"Failed to transfer data", (Throwable)e);
        }
    }

    public void removeSelection(int start, int end) {
        this.expression.removeRange(start, end);
        this.setCaretPosition(end);
        this.moveCaretPosition(start);
    }

    private void selectNodeAfter(int start) {
        ExpressionLeafNode e = this.expression.getLeafNodeStartingAt(start);
        if (e != null) {
            int end = start + e.getLength();
            this.setCaretPosition(start);
            this.moveCaretPosition(end);
        }
    }

    private void selectNodeBefore(int end) {
        ExpressionNode.TextRange tr = this.expression.getRangeForLeafNodeEndingAt(end);
        if (tr != null) {
            this.setCaretPosition(tr.t_end);
            this.moveCaretPosition(tr.t_start);
        }
    }

    public void insertText(int pos, String text) {
        int i = 0;
        while (i < text.length()) {
            this.expression.insertElementAt(new ExpressionCharNode(text.charAt(i)), pos + i);
            ++i;
        }
    }

    public void moveCaretForward(int byAmount) {
        int i = this.getSelectionStart();
        this.setText(this.generateText());
        try {
            this.setCaretPosition(i + byAmount);
        }
        catch (Exception e) {
            Log.error((String)"Failed to set caret position", (Throwable)e);
            this.setCaretPosition(this.getText().length());
        }
    }

    public void insertText(String text) {
        this.removeSelection(this.getSelectionStart(), this.getSelectionEnd());
        int i = this.getSelectionStart();
        this.insertText(i, text);
        this.setText(this.generateText());
        try {
            this.setCaretPosition(i + text.length());
        }
        catch (IllegalArgumentException e) {
            Log.error((String)"Failed to set caret position", (Throwable)e);
            this.setCaretPosition(this.getText().length());
        }
    }

    public String generateText() {
        StringBuffer s = new StringBuffer();
        this.expression.generateText(s);
        return s.toString();
    }

    public String generateScriptCode() {
        return this.expression.generateScriptCode();
    }

    @Override
    public void updateInputTextField() {
        int caretPosition = this.getCaretPosition();
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        String text = this.generateText();
        this.setText(text);
        caretPosition = this.capToLengthOfText(caretPosition, text);
        selectionEnd = this.capToLengthOfText(selectionEnd, text);
        selectionStart = this.capToLengthOfText(selectionStart, text);
        if (caretPosition == selectionStart) {
            this.setCaretPosition(selectionEnd);
            this.moveCaretPosition(selectionStart);
        } else {
            this.setCaretPosition(selectionStart);
            this.moveCaretPosition(selectionEnd);
        }
        super.setBorder(this.getExpressionBorder());
        super.setFont(this.getExpressionFont());
    }

    private Font getExpressionFont() {
        return this.expression.isUndefined() ? warningFont : normalFont;
    }

    private Border getExpressionBorder() {
        return this.expression.isUndefined() ? warningBorder : this.getNormalBorder();
    }

    private Border getNormalBorder() {
        if (this.isEnabled()) {
            return ENABLED_NORMAL_BORDER;
        }
        return DISABLED_NORMAL_BORDER;
    }

    private int capToLengthOfText(int caretPosition, String text) {
        return caretPosition > text.length() ? text.length() : caretPosition;
    }

    @Override
    public void backspace() {
        if (this.getSelectionStart() - this.getSelectionEnd() != 0) {
            this.removeSelection(this.getSelectionStart(), this.getSelectionEnd());
        } else if (this.getSelectionStart() > 0) {
            this.selectNodeBefore(this.getSelectionStart());
            this.removeSelection(this.getSelectionStart(), this.getSelectionEnd());
        }
    }

    public void delete() {
        if (this.getSelectionStart() - this.getSelectionEnd() != 0) {
            this.removeSelection(this.getSelectionStart(), this.getSelectionEnd());
        } else if (this.getSelectionStart() < this.getText().length()) {
            this.selectNodeAfter(this.getSelectionStart());
            this.removeSelection(this.getSelectionStart(), this.getSelectionEnd());
        }
    }

    private static Border createWarningBorder() {
        AbstractBorder spaceAroundOriginalBorder = new EmptyBorder(new Insets(1, 1, 1, 1));
        spaceAroundOriginalBorder = new CompoundBorder(spaceAroundOriginalBorder, new LineBorder(Color.LIGHT_GRAY, 1));
        return new CompoundBorder(new LineBorder(WARNING_COLOR, 2), spaceAroundOriginalBorder);
    }

    @Override
    public void setFont(Font font) {
        this.setFontOnlyOnceAndCreateWarningFont(font);
    }

    private void setFontOnlyOnceAndCreateWarningFont(Font font) {
        if (normalFont == null) {
            super.setFont(font);
            normalFont = font;
            warningFont = this.createWarningFont(font);
        }
    }

    private Font createWarningFont(Font font) {
        return font.deriveFont(2);
    }

    private static class ExpressionKeyMap
    implements Keymap {
        private ExpressionKeyMap() {
        }

        @Override
        public String getName() {
            return "EmptyMap";
        }

        @Override
        public Action getDefaultAction() {
            return null;
        }

        @Override
        public void setDefaultAction(Action arg0) {
        }

        @Override
        public Action getAction(KeyStroke arg0) {
            return null;
        }

        @Override
        public KeyStroke[] getBoundKeyStrokes() {
            return new KeyStroke[0];
        }

        @Override
        public Action[] getBoundActions() {
            return new Action[0];
        }

        @Override
        public KeyStroke[] getKeyStrokesForAction(Action arg0) {
            return new KeyStroke[0];
        }

        @Override
        public boolean isLocallyDefined(KeyStroke arg0) {
            return false;
        }

        @Override
        public void addActionForKeyStroke(KeyStroke arg0, Action arg1) {
        }

        @Override
        public void removeKeyStrokeBinding(KeyStroke arg0) {
        }

        @Override
        public void removeBindings() {
        }

        @Override
        public Keymap getResolveParent() {
            return this;
        }

        @Override
        public void setResolveParent(Keymap arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class FunctionKeyAdapter
    extends KeyAdapter {
        private FunctionKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            if (evt.isActionKey()) {
                return;
            }
            if (Character.isISOControl(evt.getKeyChar())) {
                return;
            }
            ExpressionEditorJTextField.this.insertText("" + evt.getKeyChar());
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (Character.isISOControl(evt.getKeyChar())) {
                if (8 == evt.getKeyCode()) {
                    ExpressionEditorJTextField.this.backspace();
                } else if (127 == evt.getKeyCode()) {
                    ExpressionEditorJTextField.this.delete();
                } else if (65487 != evt.getKeyCode() && evt.getKeyCode() != 86) {
                    Log.trace((String)("Control char pressed is " + evt.paramString()));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            ExpressionEditorJTextField.this.updateInputTextField();
        }
    }
}

