/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.lang.StringUtils;
import com.ur.swing.CloseListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.ExpressionValidator;
import com.ur.swing.expression.field.ExpressionContentProvider;
import com.ur.swing.expression.field.ExpressionHolder;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.expression.field.ExpressionPickerWrapper;
import com.ur.swing.i18n.TextResource;
import com.ur.swing.number.OnEditListener;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ExpressionField
extends JTextField {
    private static final Color WARNING_COLOR = DisplayMessageFactory.WARNING_COLOR;
    private static final Border ENABLED_NORMAL_BORDER = UIManager.getBorder("ExpressionTextField.enabledBorder");
    private static final Border DISABLED_NORMAL_BORDER = UIManager.getBorder("ExpressionTextField.disabledBorder");
    private ShowExpressionPicker expressionPicker;
    private ExpressionContentProvider contentProvider;
    private ExpressionBranchNode expression = new ExpressionBranchNode();
    private ExpressionNodeProperty node;
    private final ExpressionInserter expressionInserter;
    private final TextResource textResource;

    @Inject
    public ExpressionField(ExpressionContentProvider contentProvider, ExpressionInserter expressionInserter, TextResource textResource) {
        this.contentProvider = contentProvider;
        this.expressionInserter = expressionInserter;
        this.textResource = textResource;
        this.expressionPicker = new ShowExpressionPicker(expressionInserter);
        this.addMouseListener(this.expressionPicker);
        this.setFocusable(false);
    }

    public void setNodeWithExpression(ExpressionNodeProperty node) {
        this.node = node;
        this.expression = node.getExpression();
        this.updateInputTextField();
    }

    public void setExpression(ExpressionBranchNode e) {
        this.expression = e;
        if (this.node != null) {
            this.node.setExpression(e);
        }
        this.updateInputTextField();
    }

    public ExpressionBranchNode getExpression() {
        return this.expression;
    }

    public String generateText() {
        StringBuffer s = new StringBuffer();
        this.expression.generateText(s);
        return s.toString();
    }

    public String generateScriptCode() {
        return this.expression.generateScriptCode();
    }

    private void updateInputTextField() {
        String text = this.generateText();
        boolean hasNoExpressionText = this.hasNoExpression(text);
        this.setText(hasNoExpressionText ? "f(x)" : text);
        this.setForeground(hasNoExpressionText ? Color.LIGHT_GRAY : Color.BLACK);
        this.setBackground(this.isEnabled() && (hasNoExpressionText || this.expression.isUndefined()) ? WARNING_COLOR : Color.WHITE);
    }

    private boolean hasNoExpression(String text) {
        return StringUtils.isNullOrOnlyWhitespace((String)text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateInputTextField();
    }

    @Override
    public Border getBorder() {
        if (this.isEnabled()) {
            return ENABLED_NORMAL_BORDER;
        }
        return DISABLED_NORMAL_BORDER;
    }

    public void setExpressionValidator(ExpressionValidator expressionValidator) {
        this.getExpressionPicker().setExpressionValidator(expressionValidator);
    }

    public ShowExpressionPicker getExpressionPicker() {
        return this.expressionPicker;
    }

    private static class ExpressionHolderImpl
    implements ExpressionHolder {
        private ExpressionNodeProperty node;
        private ExpressionField expressionField;

        ExpressionHolderImpl(ExpressionNodeProperty node, ExpressionField editorJTextField) {
            this.node = node;
            this.expressionField = editorJTextField;
        }

        @Override
        public ExpressionBranchNode getExpression() {
            return this.expressionField.getExpression().clone();
        }

        @Override
        public void setExpression(ExpressionBranchNode expression) {
            if (this.node != null) {
                this.node.setExpression(expression);
            }
            this.expressionField.setExpression(expression);
            this.expressionField.postActionEvent();
        }
    }

    public class ShowExpressionPicker
    extends MouseAdapter {
        private long timeToWaitAfterClose = System.currentTimeMillis();
        private ExpressionPickerWrapper expressionPicker = null;
        private ExpressionValidator expressionValidator;

        public ShowExpressionPicker(ExpressionValidator expressionValidator) {
            this.expressionValidator = expressionValidator;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ExpressionField.this.isEnabled() || !ExpressionField.this.isEditable()) {
                return;
            }
            if (this.expressionPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                ExpressionField.this.setBackground(UIManager.getColor("textHighlight"));
                OnEditListener[] onEditListenerArray = (OnEditListener[])ExpressionField.this.listenerList.getListeners(OnEditListener.class);
                int n = onEditListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OnEditListener each = onEditListenerArray[n2];
                    each.requestEdit();
                    ++n2;
                }
                this.expressionPicker = new ExpressionPickerWrapper(new ExpressionHolderImpl(ExpressionField.this.node, ExpressionField.this), ExpressionField.this.contentProvider, ExpressionField.this.expressionInserter, this.expressionValidator, ExpressionField.this.textResource);
                this.expressionPicker.addCloseListener(new CloseListener(){

                    @Override
                    public void onClose() {
                        ShowExpressionPicker.this.expressionPicker = null;
                        ShowExpressionPicker.this.timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        ExpressionField.this.updateInputTextField();
                    }
                });
                int position = ExpressionField.this.getLocationOnScreen().y + ExpressionField.this.getHeight();
                this.expressionPicker.showInputPanelAt(ExpressionField.this, position);
            }
        }

        public void clean() {
            if (this.expressionPicker != null) {
                this.expressionPicker.clean();
                this.expressionPicker = null;
            }
        }

        public void setExpressionValidator(ExpressionValidator expressionValidator) {
            this.expressionValidator = expressionValidator;
        }
    }
}

