/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.lang.Defense;
import com.ur.swing.AbstractInputPanel;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.expression.field.ExpressionContentProvider;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.swing.expression.field.ExpressionPicker;
import com.ur.swing.expression.field.ExpressionsPanelBuilder;
import com.ur.swing.expression.field.FunctionsAndVariablesPanelBuilder;
import com.ur.swing.expression.field.NumPadPanelBuilder;
import com.ur.swing.i18n.TextResource;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ExpressionPanel
extends AbstractInputPanel {
    private static final int PANEL_STRUT = UIManager.getInt("ExpressionPicker.strut") == 0 ? 2 : UIManager.getInt("ExpressionPicker.strut");
    private final ExpressionEditorJTextField textField;
    private ExpressionPicker textPicker;
    private JButton okButton;
    private PropertyChangeListener backgroundChangeListener;

    ExpressionPanel(ExpressionEditorJTextField textField, ExpressionPicker textPicker, ExpressionContentProvider contentProvider, ExpressionInserter expressionInserter, TextResource textResource, JButton ... actions) {
        this.textField = textField;
        this.textPicker = textPicker;
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(ExpressionPicker.BACKGROUND != null ? ExpressionPicker.BACKGROUND : this.getBackground());
        NumPadPanelBuilder keypadButtonsBuilder = new NumPadPanelBuilder(textField, textPicker, textResource);
        JPanel keyPad = keypadButtonsBuilder.build();
        this.okButton = keypadButtonsBuilder.getOkButton();
        ExpressionsPanelBuilder expressionsButtonsBuilder = new ExpressionsPanelBuilder(textField, textPicker, expressionInserter, actions);
        JPanel expressions = expressionsButtonsBuilder.build();
        FunctionsAndVariablesPanelBuilder functionsAndVariablesBuilder = new FunctionsAndVariablesPanelBuilder(this, textField, textPicker, contentProvider);
        JPanel functionsAndVariables = functionsAndVariablesBuilder.build();
        this.add(functionsAndVariables);
        this.add(Box.createHorizontalStrut(PANEL_STRUT));
        this.add(expressions);
        this.add(Box.createHorizontalStrut(PANEL_STRUT));
        this.add(keyPad);
    }

    @Override
    public void setValidationStrategy(ValidationStrategy errorValidationStrategy) {
        Defense.notNull((Object)this.textField, (String)"Must have a textfield showing on keypad");
        Defense.notNull((Object)errorValidationStrategy, (String)"Validation strategy cannot be null");
        TextFieldUtils.bindValidator(this.textField, errorValidationStrategy);
    }

    @Override
    public void onShow() {
        this.updateOkEnabled();
        this.addBackgroundListener();
    }

    @Override
    public void onHide() {
        this.removeBackgroundListener();
    }

    private void addBackgroundListener() {
        this.backgroundChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExpressionPanel.this.updateOkEnabled();
            }
        };
        this.textPicker.getTextField().addPropertyChangeListener("background", this.backgroundChangeListener);
    }

    private void removeBackgroundListener() {
        this.textPicker.getTextField().removePropertyChangeListener("background", this.backgroundChangeListener);
    }

    private void updateOkEnabled() {
        Log.trace((String)("Has error: " + !DisplayMessageFactory.hasError(this.textPicker.getTextField())));
        this.okButton.setEnabled(!DisplayMessageFactory.hasError(this.textPicker.getTextField()));
    }
}

