/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.lang.Defense;
import com.ur.swing.AbstractPicker;
import com.ur.swing.InputPicker;
import com.ur.swing.ScreenUtils;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.ExpressionValidator;
import com.ur.swing.expression.field.ExpressionContentProvider;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionHolder;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.swing.expression.field.ExpressionPanel;
import com.ur.swing.expression.field.SwitchableKeyboardPanel;
import com.ur.swing.i18n.TextResource;
import com.ur.swing.resources.ButtonImageResource;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;

public class ExpressionPicker
extends AbstractPicker {
    public static final String EXPRESSION_TEXT_FIELD = "expressionTextField.ExpressionEditorPanel";
    public static final String OK_BUTTON = "OK." + ExpressionPicker.class.getSimpleName();
    public static final String TEXT_PICKER = "TEXT_PICKER." + ExpressionPicker.class.getSimpleName();
    public static final String BACKSPACE_BUTTON = "BACKSPACE." + TextPicker.class.getSimpleName();
    private static final Border KEYBOARD_BORDER = UIManager.getBorder("ExpressionPicker.border") == null ? BorderFactory.createLineBorder(Color.BLACK) : UIManager.getBorder("ExpressionPicker.border");
    private static final Border OUTER_BORDER = UIManager.getBorder("ExpressionPicker.outerBorder");
    private static final CompoundBorder SELECTED_COMPONENT_BORDER = new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1), new LineBorder(Color.LIGHT_GRAY, 2));
    static final Dimension BUTTON_DIMENSIONS = UIManager.getDimension("TextPicker.dimensions") == null ? new Dimension(38, 42) : UIManager.getDimension("TextPicker.dimensions");
    static final int PADDING = UIManager.getInt("TextPicker.padding");
    static final Color BACKGROUND = UIManager.getColor("TextPicker.background");
    static final Color NUMBER_KEYS = UIManager.getColor("NumberPicker.numberKeysColor");
    static final Color OTHER_KEYS = UIManager.getColor("NumberPicker.otherKeysColor");
    static final Font BOLD_FONT = UIManager.getFont("TextPicker.font");
    static final Font OTHER_BOLD_FONT = UIManager.getFont("TextPicker.otherFont");
    private static final int INPUT_FIELD_HORIZONTAL_PADDING = 80;
    private final InputMap inputMap;
    private final ActionMap actionMap;
    private final ExpressionEditorJTextField expressionTextField;
    private final ExpressionValidator expressionValidator;
    ExpressionHolder provider;

    public ExpressionPicker(ExpressionHolder provider, ExpressionContentProvider contentProvider, ExpressionInserter expressionInserter, ExpressionValidator expressionValidator, TextResource textResource) {
        super(new ExpressionEditorJTextField());
        this.expressionTextField = (ExpressionEditorJTextField)this.textField;
        Defense.notNull((Object)provider, (String)"ExpressionHolder cannot be null");
        Defense.notNull((Object)contentProvider, (String)"ExpressionContentProvider cannot be null");
        this.provider = provider;
        this.expressionValidator = expressionValidator;
        this.textField.setPreferredSize(new Dimension(-1, ExpressionPicker.BUTTON_DIMENSIONS.height));
        this.textField.setSize(-1, ExpressionPicker.BUTTON_DIMENSIONS.height);
        this.textField.setName(EXPRESSION_TEXT_FIELD);
        this.expressionTextField.setExpression(provider.getExpression());
        this.keyboardDialog.getRootPane().setBorder(OUTER_BORDER);
        this.keyboardDialog.getRootPane().setWindowDecorationStyle(0);
        JPanel contentPane = (JPanel)this.keyboardDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.actionMap = contentPane.getActionMap();
        this.inputMap = contentPane.getInputMap(2);
        this.pressEscapeKey(this.textField);
        this.pressEnterKey();
        if (this.keyboardPanel != null) {
            this.keyboardDialog.getContentPane().remove(this.keyboardPanel);
        }
        this.textField.setCaretPosition(this.textField.getText().length());
        JPanel textToFunctionPanel = new JPanel(new CardLayout());
        final SwitchableKeyboardPanel keyboardPanel = new SwitchableKeyboardPanel(this.expressionTextField, new SwitchToCard(textToFunctionPanel, "f(x)", new ActionListener[0]));
        ActionListener abcActivatedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                keyboardPanel.keyboardOn();
            }
        };
        textToFunctionPanel.add((Component)new JPanel(new BorderLayout(), contentProvider, expressionInserter, textResource, textToFunctionPanel, abcActivatedListener){
            {
                ExpressionPicker.this.keyboardPanel = new ExpressionPanel(ExpressionPicker.this.expressionTextField, ExpressionPicker.this, expressionContentProvider, expressionInserter, textResource, new SwitchToCard(jPanel, "ABC", actionListener));
                this.add((Component)ExpressionPicker.this.keyboardPanel, "Center");
                this.setBackground(BACKGROUND);
                this.setBorder(KEYBOARD_BORDER);
            }
        }, "f(x)");
        textToFunctionPanel.add((Component)new JPanel(new BorderLayout(), keyboardPanel){
            {
                this.add((Component)switchableKeyboardPanel, "Center");
                this.setBackground(BACKGROUND);
                this.setBorder(TextPicker.KEYBOARD_BORDER);
            }
        }, "ABC");
        this.keyboardDialog.getContentPane().add((Component)this.createTextInputPanel(this.textField), "North");
        this.keyboardDialog.getContentPane().add((Component)textToFunctionPanel, "Center");
        this.keyboardDialog.setBackground(BACKGROUND);
        TextFieldUtils.bindValidator(this.textField, new ValidationStrategy(){

            @Override
            public boolean isValid(String uncheckedString) {
                if (ExpressionPicker.this.expressionValidator != null) {
                    String generatedScript = ExpressionPicker.this.expressionTextField.generateScriptCode();
                    return ExpressionPicker.this.expressionValidator.isValid(generatedScript);
                }
                return false;
            }

            @Override
            public String getErrorMessage(String uncheckedString) {
                return null;
            }
        });
        this.keyboardDialog.pack();
    }

    private JPanel createTextInputPanel(JTextComponent textField) {
        JPanel textInputPanel = new JPanel(new BorderLayout());
        textInputPanel.add(Box.createHorizontalStrut(80), "West");
        textInputPanel.add((Component)textField, "Center");
        textInputPanel.add(Box.createHorizontalStrut(80), "East");
        return textInputPanel;
    }

    @Override
    public String getName() {
        return TEXT_PICKER;
    }

    @Override
    public void onShow() {
        Rectangle frameBounds = this.keyboardDialog.getParent().getBounds();
        Rectangle screenBounds = ScreenUtils.getScreenBounds();
        this.visiblePositionY = screenBounds.y - frameBounds.y + this.visiblePositionY;
        int screenY = screenBounds.y + screenBounds.height - this.keyboardDialog.getHeight();
        this.keyboardDialog.setBounds(screenBounds.x, screenY, (int)screenBounds.getWidth(), this.keyboardDialog.getHeight());
        this.keyboardDialog.setVisible(true);
    }

    @Override
    public void onApply() {
        this.provider.setExpression(this.expressionTextField.getExpression());
        this.completedListener.requestApply();
    }

    private void pressEnterKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("ENTER"), "Enter");
        this.actionMap.put("Enter", new AbstractAction(){
            private static final long serialVersionUID = 1130993426922231973L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionPicker.this.hideInputPanel(InputPicker.Request.Apply);
            }
        });
    }

    private void pressEscapeKey(final JTextComponent field) {
        this.inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "Escape");
        this.actionMap.put("Escape", new AbstractAction(){
            String originalText;
            {
                this.originalText = jTextComponent.getText();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                field.setText(this.originalText);
                ExpressionPicker.this.hideInputPanel(InputPicker.Request.Cancel);
            }
        });
    }

    public static boolean isSelected(Object border) {
        return SELECTED_COMPONENT_BORDER.equals(border);
    }

    static class DUMMY
    implements ExpressionHolder {
        DUMMY() {
        }

        @Override
        public ExpressionBranchNode getExpression() {
            return null;
        }

        @Override
        public void setExpression(ExpressionBranchNode text) {
        }
    }

    static class FunctionKey
    extends JButton {
        public FunctionKey(String display, String function, int width, final ExpressionEditorJTextField component, final ExpressionInserter expressionInserter) {
            this.setText(display);
            this.setName(function);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    expressionInserter.insertToken(component, " " + FunctionKey.super.getName() + " ");
                    component.updateInputTextField();
                    component.requestFocus();
                }
            });
            this.setBackground(OTHER_KEYS);
            this.setFont(BOLD_FONT);
            this.setSize(ExpressionPicker.BUTTON_DIMENSIONS.width * width + PADDING * (width - 1), ExpressionPicker.BUTTON_DIMENSIONS.height);
            this.setFocusable(false);
        }
    }

    static class OnScreenKey
    extends JButton {
        OnScreenKey(char mainChar, final ExpressionEditorJTextField component) {
            this.setText(Character.toString(mainChar));
            this.setName(Character.toString(mainChar));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    component.insertText(this.getText());
                    component.updateInputTextField();
                    component.requestFocus();
                }
            });
            this.setBackground(mainChar == '-' || mainChar == '.' ? OTHER_KEYS : NUMBER_KEYS);
            this.setFont(BOLD_FONT);
            this.setSize(mainChar == '0' ? ExpressionPicker.BUTTON_DIMENSIONS.width * 2 + PADDING : ExpressionPicker.BUTTON_DIMENSIONS.width, ExpressionPicker.BUTTON_DIMENSIONS.height);
            this.setFocusable(false);
        }
    }

    static class SpecialKey
    extends JButton {
        SpecialKey(char key, ExpressionEditorJTextField component, ExpressionInserter expressionInserter) {
            this(Character.toString(key), key, component, expressionInserter);
        }

        SpecialKey(String display, final char key, final ExpressionEditorJTextField component, final ExpressionInserter expressionInserter) {
            this.setText(display);
            this.setName(display);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    expressionInserter.insertSpecialChar(component, key);
                    component.updateInputTextField();
                    component.requestFocus();
                }
            });
            this.setBackground(NUMBER_KEYS);
            if (BOLD_FONT.getFamily().equals("DejaVu")) {
                this.setFont(BOLD_FONT);
            } else {
                this.setFont(new Font("Dialog", BOLD_FONT.getStyle(), BOLD_FONT.getSize()));
            }
            this.setSize(ExpressionPicker.BUTTON_DIMENSIONS.width, ExpressionPicker.BUTTON_DIMENSIONS.height);
            this.setFocusable(false);
        }
    }

    static class SwitchToCard
    extends JButton {
        SwitchToCard(final JPanel textToFunctionPanel, final String text, ActionListener ... actionListeners) {
            this.setBackground(OTHER_KEYS);
            this.setText(text);
            this.setFont(OTHER_BOLD_FONT);
            this.setIcon(ButtonImageResource.keyboard());
            this.setSize(ExpressionPicker.BUTTON_DIMENSIONS.width * 2 + PADDING, ExpressionPicker.BUTTON_DIMENSIONS.height);
            this.setHorizontalTextPosition(2);
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CardLayoutUtil.flipToCard(textToFunctionPanel, text);
                }
            });
            ActionListener[] actionListenerArray = actionListeners;
            int n = actionListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener actionListener = actionListenerArray[n2];
                this.addActionListener(actionListener);
                ++n2;
            }
        }
    }

    static class WideComboBox
    extends JComboBox {
        private boolean layingOut = false;

        WideComboBox() {
        }

        @Override
        public void doLayout() {
            try {
                this.layingOut = true;
                super.doLayout();
            }
            finally {
                this.layingOut = false;
            }
        }

        @Override
        public Dimension getSize() {
            Dimension dim = super.getSize();
            if (!this.layingOut) {
                dim.width = Math.max(dim.width, this.getPreferredSize().width);
            }
            return dim;
        }
    }
}

