/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.swing.expression.field.AbstractExpressionPickerPanelBuilder;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionInserter;
import com.ur.swing.expression.field.ExpressionPicker;
import com.ur.swing.resources.ButtonImageResource;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteLayout;

class ExpressionsPanelBuilder
extends AbstractExpressionPickerPanelBuilder {
    private final ExpressionInserter expressionInserter;
    private final JButton[] actions;

    public ExpressionsPanelBuilder(ExpressionEditorJTextField textField, ExpressionPicker textPicker, ExpressionInserter expressionInserter, JButton ... actions) {
        super(textField, textPicker);
        this.expressionInserter = expressionInserter;
        this.actions = actions;
    }

    @Override
    protected JPanel buildPanel() {
        JPanel panel = new JPanel((LayoutManager)new AbsoluteLayout());
        panel.setBackground(ExpressionPicker.BACKGROUND);
        return panel;
    }

    @Override
    protected List<List<JComponent>> buildRows() {
        JButton space = this.spaceBar(this.textField);
        JButton left = this.leftArrowKey(this.textField);
        JButton right = this.rightArrowKey(this.textField);
        ArrayList<List<JComponent>> list = new ArrayList<List<JComponent>>();
        list.add(this.buildRow1());
        list.add(this.buildRow2());
        list.add(this.buildRow3());
        list.add(this.buildRow4());
        list.add(this.buildRow5(this.actions, space, left, right));
        return list;
    }

    private List<JComponent> buildRow1() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        row.add(new ExpressionPicker.FunctionKey("True (HI)", "True", 4, this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.FunctionKey("False (LO)", "False", 4, this.textField, this.expressionInserter));
        return row;
    }

    private List<JComponent> buildRow2() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        row.add(new ExpressionPicker.FunctionKey("and", "and", 2, this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.FunctionKey("or", "or", 2, this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.FunctionKey("xor", "xor", 2, this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.FunctionKey("not", "not", 2, this.textField, this.expressionInserter));
        return row;
    }

    private List<JComponent> buildRow3() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        row.add(new ExpressionPicker.SpecialKey("\u225f", '\u225f', this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.SpecialKey("<html>&#8800</html>", '\u2260', this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.OnScreenKey('(', this.textField));
        row.add(new ExpressionPicker.OnScreenKey(')', this.textField));
        row.add(new ExpressionPicker.SpecialKey('<', this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.SpecialKey('>', this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.OnScreenKey('/', this.textField));
        row.add(new ExpressionPicker.OnScreenKey('*', this.textField));
        return row;
    }

    private List<JComponent> buildRow4() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        row.add(new ExpressionPicker.OnScreenKey('_', this.textField));
        row.add(new ExpressionPicker.OnScreenKey('\"', this.textField));
        row.add(new ExpressionPicker.OnScreenKey('[', this.textField));
        row.add(new ExpressionPicker.OnScreenKey(']', this.textField));
        row.add(new ExpressionPicker.SpecialKey("<html>&#8804</html>", '\u2264', this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.SpecialKey("<html>&#8805</html>", '\u2265', this.textField, this.expressionInserter));
        row.add(new ExpressionPicker.OnScreenKey(',', this.textField));
        row.add(new ExpressionPicker.OnScreenKey('+', this.textField));
        return row;
    }

    private List<JComponent> buildRow5(JButton[] actions, JButton space, JButton left, JButton right) {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        JButton[] jButtonArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            JButton each = jButtonArray[n2];
            row.add(each);
            ++n2;
        }
        row.add(space);
        row.add(left);
        row.add(right);
        return row;
    }

    private JButton spaceBar(final ExpressionEditorJTextField textField) {
        JButton result = this.createSpecialKey("", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                textField.insertText(" ");
                textField.updateInputTextField();
                textField.requestFocus();
            }
        });
        result.setSize(new Dimension(ExpressionPicker.BUTTON_DIMENSIONS.width * 4 + ExpressionPicker.PADDING * 3, ExpressionPicker.BUTTON_DIMENSIONS.height));
        result.setBackground(ExpressionPicker.NUMBER_KEYS);
        return result;
    }

    private JButton leftArrowKey(JTextComponent textField) {
        JButton result = this.arrowKey("caret-backward", textField);
        result.setIcon(ButtonImageResource.leftArrow());
        return result;
    }

    private JButton rightArrowKey(JTextComponent textField) {
        JButton result = this.arrowKey("caret-forward", textField);
        result.setIcon(ButtonImageResource.rightArrow());
        return result;
    }

    private JButton arrowKey(final String styledEditorKitLookup, final JTextComponent textField) {
        JButton result = this.createSpecialKey("", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                textField.getActionMap().get(styledEditorKitLookup).actionPerformed(evt);
                textField.requestFocus();
            }
        });
        result.setSize(new Dimension(ExpressionPicker.BUTTON_DIMENSIONS.width, ExpressionPicker.BUTTON_DIMENSIONS.height));
        return result;
    }
}

