/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.swing.expression.field.AbstractExpressionPickerPanelBuilder;
import com.ur.swing.expression.field.ExpressionContentProvider;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionPanel;
import com.ur.swing.expression.field.ExpressionPicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteLayout;

class FunctionsAndVariablesPanelBuilder
extends AbstractExpressionPickerPanelBuilder {
    private static final boolean DOUBLE_WIDTH = true;
    private static final boolean NORMAL_WIDTH = false;
    private static final int WIDTH_ADJUSTMENT = 3;
    private ExpressionPanel expressionPanel;
    private final ExpressionContentProvider contentProvider;

    FunctionsAndVariablesPanelBuilder(ExpressionPanel expressionPanel, ExpressionEditorJTextField textField, ExpressionPicker textPicker, ExpressionContentProvider contentProvider) {
        super(textField, textPicker);
        this.expressionPanel = expressionPanel;
        this.contentProvider = contentProvider;
    }

    @Override
    protected JPanel buildPanel() {
        JPanel functionsAndVariables = new JPanel((LayoutManager)new AbsoluteLayout());
        functionsAndVariables.setBackground(ExpressionPicker.BACKGROUND);
        return functionsAndVariables;
    }

    @Override
    protected List<List<JComponent>> buildRows() {
        ArrayList<List<JComponent>> list = new ArrayList<List<JComponent>>();
        boolean ioWidth = this.contentProvider.longIONames();
        list.add(this.functions("Input", this.contentProvider.inputSelection(this.textField, ioWidth)));
        list.add(this.functions("Output", this.contentProvider.outputSelection(this.textField, ioWidth)));
        list.add(this.functions("Variable", this.contentProvider.variableSelection(this.textField, false)));
        list.add(this.functions("Pose", this.contentProvider.poseSelection(this.textField, false)));
        list.add(this.functions("Function", this.contentProvider.functionSelection(this.textField, true)));
        return list;
    }

    private List<JComponent> functions(String textLabel, JComboBox comboBox) {
        JPanel panel = new JPanel(new BorderLayout(ExpressionPicker.PADDING, ExpressionPicker.PADDING));
        panel.setBorder(BorderFactory.createEmptyBorder(ExpressionPicker.PADDING, 0, 0, 0));
        panel.add((Component)new JLabel(textLabel){
            {
                this.setFont(ExpressionPicker.OTHER_BOLD_FONT);
                this.setForeground(ExpressionPicker.OTHER_KEYS == null ? null : ExpressionPicker.OTHER_KEYS.darker());
                FunctionsAndVariablesPanelBuilder.this.expressionPanel.setAlignmentY(1.0f);
            }
        }, "North");
        panel.add((Component)comboBox, "Center");
        panel.setSize(ExpressionPicker.BUTTON_DIMENSIONS.width * 3 + 2 * ExpressionPicker.PADDING - 3, ExpressionPicker.BUTTON_DIMENSIONS.height);
        panel.setPreferredSize(panel.getSize());
        panel.setMinimumSize(panel.getSize());
        panel.setBackground(ExpressionPicker.BACKGROUND);
        return Arrays.asList(panel);
    }
}

