/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;

abstract class KeyboardButtonsBuilder {
    private final int buttonHeight;
    private final int buttonPadding;
    protected int padding = 1;
    protected int buttonRow = 0;

    protected KeyboardButtonsBuilder(int buttonHeight, int buttonPadding) {
        this.buttonHeight = buttonHeight;
        this.buttonPadding = buttonPadding;
    }

    protected abstract JPanel buildPanel();

    protected abstract List<List<JComponent>> buildRows();

    public JPanel build() {
        JPanel panel = this.buildPanel();
        List<List<JComponent>> rows = this.buildRows();
        for (List<JComponent> each : rows) {
            this.addRow(panel, each);
        }
        return panel;
    }

    private void addRow(JPanel panel, List<JComponent> components) {
        this.attachButtonsStartingAt(panel, 0, this.padding + this.buttonHeight * this.buttonRow, components);
        this.padding += this.buttonPadding;
        ++this.buttonRow;
    }

    private void attachButtonsStartingAt(JPanel panel, int startX, int startY, List<JComponent> row) {
        int x = startX;
        int y = startY;
        int i = 0;
        while (i < row.size()) {
            JComponent component = row.get(i);
            component.setLocation(x, y);
            panel.add((Component)component, new AbsoluteConstraints(x, y, component.getWidth(), component.getHeight()));
            x += this.buttonPadding + component.getWidth();
            ++i;
        }
    }
}

