/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.expression.field;

import com.ur.swing.InputPicker;
import com.ur.swing.LongPressEraseDelegate;
import com.ur.swing.expression.field.AbstractExpressionPickerPanelBuilder;
import com.ur.swing.expression.field.ExpressionEditorJTextField;
import com.ur.swing.expression.field.ExpressionPicker;
import com.ur.swing.i18n.TextResource;
import com.ur.swing.resources.ButtonImageResource;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.awtextra.AbsoluteLayout;

class NumPadPanelBuilder
extends AbstractExpressionPickerPanelBuilder {
    private JButton okButton;
    private final TextResource textResource;

    NumPadPanelBuilder(ExpressionEditorJTextField textField, ExpressionPicker textPicker, TextResource textResource) {
        super(textField, textPicker);
        this.textResource = textResource;
    }

    @Override
    protected JPanel buildPanel() {
        JPanel panel = new JPanel((LayoutManager)new AbsoluteLayout());
        panel.setBackground(ExpressionPicker.BACKGROUND);
        return panel;
    }

    @Override
    protected List<List<JComponent>> buildRows() {
        JButton backspace = this.backspaceKey(this.textResource.backspace(), this.textField);
        JButton esc = this.createEscButton(this.textField);
        this.okButton = this.createOkButton();
        ArrayList<List<JComponent>> list = new ArrayList<List<JComponent>>();
        list.add(this.buildRow1(esc, backspace));
        list.add(this.buildRow2());
        list.add(this.buildRow3(this.okButton));
        list.add(this.buildRow4());
        list.add(this.buildRow5());
        return list;
    }

    private ArrayList<JComponent> buildRow1(JButton esc, JButton backspace) {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        row.add(esc);
        row.add(backspace);
        return row;
    }

    private ArrayList<JComponent> buildRow2() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        char[] cArray = "789-".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            row.add(new ExpressionPicker.OnScreenKey(each, this.textField));
            ++n2;
        }
        return row;
    }

    private ArrayList<JComponent> buildRow3(JButton submit) {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        char[] cArray = "456".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            row.add(new ExpressionPicker.OnScreenKey(each, this.textField));
            ++n2;
        }
        row.add(submit);
        return row;
    }

    private ArrayList<JComponent> buildRow4() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        char[] cArray = "123".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            row.add(new ExpressionPicker.OnScreenKey(each, this.textField));
            ++n2;
        }
        return row;
    }

    private ArrayList<JComponent> buildRow5() {
        ArrayList<JComponent> row = new ArrayList<JComponent>();
        char[] cArray = "0.".toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            row.add(new ExpressionPicker.OnScreenKey(each, this.textField));
            ++n2;
        }
        return row;
    }

    private JButton createEscButton(final JTextComponent textField) {
        JButton result = this.createSpecialKey("Esc", new ActionListener(){
            private final String originalText;
            {
                this.originalText = jTextComponent.getText();
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                textField.setText(this.originalText);
                if (NumPadPanelBuilder.this.textPicker.getTextField().isEnabled()) {
                    NumPadPanelBuilder.this.textPicker.hideInputPanel(InputPicker.Request.Cancel);
                }
                NumPadPanelBuilder.this.textPicker.getTextField().setEnabled(false);
            }
        });
        result.setFont(ExpressionPicker.OTHER_BOLD_FONT);
        result.setIcon(ButtonImageResource.escape());
        result.setBackground(ExpressionPicker.OTHER_KEYS);
        result.setVerticalTextPosition(3);
        result.setHorizontalTextPosition(0);
        result.setSize(new Dimension(ExpressionPicker.BUTTON_DIMENSIONS.width, ExpressionPicker.BUTTON_DIMENSIONS.height));
        return result;
    }

    private JButton backspaceKey(String text, final ExpressionEditorJTextField textField) {
        JButton result = this.createSpecialKey(text);
        new LongPressEraseDelegate(result, textField){

            @Override
            protected void longPressAction() {
                textField.backspace();
                textField.setCaretPosition(textField.getSelectionStart());
                textField.updateInputTextField();
            }

            @Override
            protected void buttonReleased() {
                textField.requestFocusInWindow();
            }
        };
        result.setFont(ExpressionPicker.OTHER_BOLD_FONT);
        result.setIcon(ButtonImageResource.backspace());
        result.setSize(ExpressionPicker.BUTTON_DIMENSIONS.width * 3 + ExpressionPicker.PADDING * 2, result.getHeight());
        result.setName(ExpressionPicker.BACKSPACE_BUTTON);
        return result;
    }

    private JButton createOkButton() {
        JButton result = this.createSpecialKey(this.textResource.submit(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NumPadPanelBuilder.this.textPicker.getTextField().isEnabled()) {
                    NumPadPanelBuilder.this.textPicker.hideInputPanel(InputPicker.Request.Apply);
                }
                NumPadPanelBuilder.this.textPicker.getTextField().setEnabled(false);
            }
        });
        result.setFont(ExpressionPicker.OTHER_BOLD_FONT);
        result.setIcon(ButtonImageResource.submit());
        result.setSize(new Dimension(ExpressionPicker.BUTTON_DIMENSIONS.width, ExpressionPicker.BUTTON_DIMENSIONS.height * 3 + 2 * ExpressionPicker.PADDING));
        result.setVerticalTextPosition(3);
        result.setHorizontalTextPosition(0);
        result.setMargin(new Insets(0, -20, 0, -20));
        result.setName(ExpressionPicker.OK_BUTTON);
        return result;
    }

    public JButton getOkButton() {
        return this.okButton;
    }
}

