/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.extensible;

import com.ur.injection.Builder;
import com.ur.lang.EqualsUtil;
import com.ur.swing.CardPanel;
import com.ur.swing.CardPanelListener;
import com.ur.swing.ComponentView;
import com.ur.swing.extensible.AddLayer;
import com.ur.swing.extensible.AddToView;
import com.ur.swing.extensible.AddToViewExtension;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.FooterExtension;
import com.ur.swing.extensible.HeaderExtension;
import com.ur.swing.extensible.LayerExtension;
import com.ur.swing.extensible.LeftOf;
import com.ur.swing.extensible.LeftOfExtension;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.extensible.VerticalPlacement;
import com.ur.swing.extensible.VerticalPlacementExtension;
import com.ur.util.logging.Log;
import java.util.Set;
import javax.inject.Inject;

public class ContributeExtensionPoints {
    public static void loadExtensions(Builder builder) {
        ContributeExtensionPoints.tryToGet(builder, BindToLeftOf.class);
        ContributeExtensionPoints.tryToGet(builder, BindToFooter.class);
        ContributeExtensionPoints.tryToGet(builder, BindToHeader.class);
        ContributeExtensionPoints.tryToGet(builder, BindToMenu.class);
        ContributeExtensionPoints.tryToGet(builder, BindToView.class);
        ContributeExtensionPoints.tryToGet(builder, BindToLayer.class);
        ContributeExtensionPoints.tryToGet(builder, BindToVerticalPlacement.class);
        ContributeExtensionPoints.tryToGet(builder, BindToCardPanelListeners.class);
    }

    private static void tryToGet(Builder builder, Class<?> typeToFetch) {
        try {
            builder.get(typeToFetch);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Log.error((String)"Extension loading error caused by ", (Throwable)e.getCause());
            }
            Log.info((String)("Failed to create an instance of " + typeToFetch));
        }
    }

    private static abstract class BaseBinder<E, EP> {
        public BaseBinder(Set<E> extensions, Set<EP> extensionPoints) {
            for (E eachExtension : extensions) {
                boolean wasBound = false;
                for (EP eachExtensionPoint : extensionPoints) {
                    String extensionPointName;
                    String extensionName = this.getExtensionName(eachExtension);
                    if (!EqualsUtil.equals((Object)extensionName, (Object)(extensionPointName = this.getExtensionPointName(eachExtensionPoint)))) continue;
                    wasBound = true;
                    try {
                        Log.debug((String)("Contributing " + eachExtension.getClass().getName() + " and " + eachExtensionPoint.getClass().getName() + " for " + extensionPointName));
                        this.contributeExtensionToExtensionPoint(eachExtension, eachExtensionPoint);
                    }
                    catch (Exception e) {
                        Log.error((String)("Failed to contribute to " + extensionPointName), (Throwable)e);
                    }
                }
                if (wasBound) continue;
                throw new UnboundExtensionException(eachExtension);
            }
        }

        private String getExtensionName(Object subject) {
            Extension extension = subject.getClass().getAnnotation(Extension.class);
            if (extension != null) {
                return extension.value();
            }
            return "";
        }

        private String getExtensionPointName(Object subject) {
            ExtensionPoint point = subject.getClass().getAnnotation(ExtensionPoint.class);
            if (point != null) {
                return point.value();
            }
            return "";
        }

        protected abstract void contributeExtensionToExtensionPoint(E var1, EP var2);
    }

    static class BindToCardPanelListeners
    extends BaseBinder<CardPanelListener, CardPanel> {
        @Inject
        public BindToCardPanelListeners(Set<CardPanelListener> extensions, Set<CardPanel> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(CardPanelListener extension, CardPanel extensionPoint) {
            extensionPoint.addCardPanelListener(extension);
        }
    }

    static class BindToFooter
    extends BaseBinder<FooterExtension, ComponentView> {
        @Inject
        public BindToFooter(Set<FooterExtension> extensions, Set<ComponentView> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(FooterExtension extension, ComponentView extensionPoint) {
            extensionPoint.setFooter(extension.createFooter());
        }
    }

    static class BindToHeader
    extends BaseBinder<HeaderExtension, ComponentView> {
        @Inject
        public BindToHeader(Set<HeaderExtension> extensions, Set<ComponentView> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(HeaderExtension extension, ComponentView extensionPoint) {
            extensionPoint.setHeader(extension.createHeader());
        }
    }

    static class BindToLayer
    extends BaseBinder<LayerExtension, AddLayer> {
        @Inject
        public BindToLayer(Set<LayerExtension> extensions, Set<AddLayer> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(LayerExtension extension, AddLayer extensionPoint) {
            extensionPoint.addLayer(extension.createLayer());
        }
    }

    static class BindToLeftOf
    extends BaseBinder<LeftOfExtension, LeftOf> {
        @Inject
        public BindToLeftOf(Set<LeftOfExtension> extensions, Set<LeftOf> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(LeftOfExtension extension, LeftOf extensionPoint) {
            extensionPoint.setLeftPanel(extension.create());
        }
    }

    static class BindToMenu
    extends BaseBinder<MenuExtension, Menu> {
        @Inject
        public BindToMenu(Set<MenuExtension> extensions, Set<Menu> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(MenuExtension extension, Menu extensionPoint) {
            extensionPoint.addMenuItem(extension.create());
        }
    }

    static class BindToVerticalPlacement
    extends BaseBinder<VerticalPlacementExtension, VerticalPlacement> {
        @Inject
        public BindToVerticalPlacement(Set<VerticalPlacementExtension> extensions, Set<VerticalPlacement> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(VerticalPlacementExtension extension, VerticalPlacement extensionPoint) {
            extensionPoint.addComponent(extension.create());
        }
    }

    static class BindToView
    extends BaseBinder<AddToViewExtension, AddToView> {
        @Inject
        public BindToView(Set<AddToViewExtension> extensions, Set<AddToView> extensionPoints) {
            super(extensions, extensionPoints);
        }

        @Override
        protected void contributeExtensionToExtensionPoint(AddToViewExtension extension, AddToView extensionPoint) {
            extensionPoint.addComponent(extension.create());
        }
    }

    public static class UnboundExtensionException
    extends RuntimeException {
        public UnboundExtensionException(Object eachExtension) {
            super("Was unable to bind extension point " + eachExtension.getClass());
        }
    }
}

