/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.extensible;

import com.ur.swing.AbstractActionDefinition;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public interface MenuExtension {
    public static final int FIRST_ITEM = 1000;
    public static final int MIDDLE = 2000;
    public static final int LAST_ITEM = 3000;

    public MenuContribution create();

    public static abstract class AbstractOverlayAction
    extends AbstractActionDefinition
    implements OverlayAction {
        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.notifyOverlayEnabled(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.notifyOverlayEnabled(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.notifyOverlayEnabled(false);
        }

        @Override
        public void notifyOverlayEnabled(boolean enabled) {
            this.putValue("overlayEnabled", enabled);
        }

        @Override
        public boolean isOverlayEnabled() {
            return (Boolean)this.getValue("overlayEnabled");
        }

        @Override
        public boolean isRestrictive() {
            return false;
        }
    }

    public static class ComponentMenuContribution
    extends MenuContribution {
        private final JComponent component;

        public ComponentMenuContribution(JComponent component, String category) {
            super(new EmptyAction(), category);
            this.component = component;
        }

        public ComponentMenuContribution(JComponent component, String category, MenuContribution.Restrictions restriction) {
            super(new EmptyAction(), category, restriction);
            this.component = component;
        }

        public ComponentMenuContribution(JComponent component, Action action, String category) {
            super(action, category);
            this.component = component;
        }

        public ComponentMenuContribution(JComponent component, Action action, String category, MenuContribution.Restrictions restrictions) {
            super(action, category, restrictions);
            this.component = component;
        }

        @Override
        public JComponent createComponent(Action action) {
            return this.component;
        }

        @Override
        public MenuContribution.Restrictions getDefaultRestriction() {
            return this.restriction;
        }
    }

    public static class EmptyAction
    implements Action {
        @Override
        public Object getValue(String key) {
            return "";
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public static class EnumMenuContribution<T extends Enum<T>>
    extends MenuContribution {
        private T category;

        public EnumMenuContribution(Action contribution, T category) {
            super(contribution);
            this.category = category;
        }

        public T getMenuCategory() {
            return this.category;
        }
    }

    public static class MenuContribution {
        public final Action contribution;
        private final String category;
        private int priority = 1000;
        protected final Restrictions restriction;

        public MenuContribution(Action contribution) {
            this(contribution, "default");
        }

        public MenuContribution(Action contribution, String category, Restrictions restriction) {
            this.contribution = contribution;
            this.category = category;
            this.restriction = restriction;
        }

        public MenuContribution(Action contribution, String category) {
            this.contribution = contribution;
            this.category = category;
            this.restriction = Restrictions.UNDEFINED;
        }

        public MenuContribution(OverlayAction contribution) {
            this.contribution = contribution;
            this.restriction = Restrictions.UNDEFINED;
            this.category = "default";
            contribution.notifyOverlayEnabled(false);
        }

        public static MenuContribution locateLast(MenuContribution contribution) {
            contribution.priority = 3000;
            return contribution;
        }

        public static MenuContribution locateMiddle(MenuContribution contribution) {
            contribution.priority = 2000;
            return contribution;
        }

        public static MenuContribution locateBefore(int priority, MenuContribution contribution) {
            contribution.priority = priority - 333;
            return contribution;
        }

        public static MenuContribution locateAfter(int priority, MenuContribution contribution) {
            contribution.priority = priority + 321;
            return contribution;
        }

        @Deprecated
        public AbstractButton createButton(Action action) {
            return new JButton(action);
        }

        public JComponent createComponent(Action action) {
            return this.createButton(action);
        }

        public final int getPriority() {
            return this.priority;
        }

        public final String getCategory() {
            return this.category;
        }

        public Restrictions getDefaultRestriction() {
            return this.restriction;
        }

        public static enum Restrictions {
            UNDEFINED,
            NO_RESTRICTION,
            RESTRICT_FOR_AUTOMATIC;

        }
    }

    public static interface OverlayAction
    extends Action,
    PopupMenuListener {
        public static final String OVERLAY_ENABLED_PROPERTY = "overlayEnabled";

        public void notifyOverlayEnabled(boolean var1);

        public boolean isOverlayEnabled();

        public boolean isRestrictive();

        public Object[] getKeys();
    }
}

