/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.extensible;

import java.awt.Component;

public interface VerticalPlacementExtension {
    public static final int FIRST_ITEM = 1000;
    public static final int MIDDLE = 2000;
    public static final int LAST_ITEM = 3000;

    public PlacementContribution create();

    public static class PlacementContribution {
        private final Component component;
        private int priority = 1000;

        public PlacementContribution(Component contribution) {
            this.component = contribution;
        }

        public static PlacementContribution locateLast(PlacementContribution component) {
            component.priority = 3000;
            return component;
        }

        public static PlacementContribution locateMiddle(PlacementContribution component) {
            component.priority = 2000;
            return component;
        }

        public static PlacementContribution locateBefore(int priority, PlacementContribution component) {
            component.priority = priority - 333;
            return component;
        }

        public static PlacementContribution locateAfter(int priority, PlacementContribution component) {
            component.priority = priority + 321;
            return component;
        }

        public Component getComponent() {
            return this.component;
        }

        public final int getPriority() {
            return this.priority;
        }
    }
}

