/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.flippable;

import com.ur.lang.ClassUtils;
import com.ur.lang.Defense;
import com.ur.swing.CardChangedListener;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.SwitchSupport;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class FlippablePanel
extends JPanel
implements FlipManager,
SwitchSupport.Callback {
    private final CardLayout cardLayout = new CardLayout();
    private final SwitchSupport switchSupport;

    public FlippablePanel() {
        this.setLayout(this.cardLayout);
        this.switchSupport = new SwitchSupport(this);
    }

    @Override
    public CardPanel getCurrentCard() {
        return this.switchSupport.getCurrentCard();
    }

    @Override
    public CardPanel getCardParent() {
        return this.switchSupport.getCardParent();
    }

    @Override
    public void setCardParent(CardPanel cardPanel) {
        this.switchSupport.setCardParent(cardPanel);
        cardPanel.addChild(this);
    }

    @Override
    public void resetAll() {
        this.switchSupport.resetAll();
    }

    @Override
    public boolean canReset() {
        if (this.getCurrentCard() != null && !this.getCurrentCard().isAllowedToExit()) {
            return false;
        }
        return this.switchSupport.canReset();
    }

    @Override
    public void enterActiveChild(Object o) {
        this.switchSupport.enterActiveChild(o);
    }

    @Override
    public Object exitActiveChild() {
        return this.switchSupport.exitActiveChild();
    }

    @Override
    public void addCardPanel(CardPanel panelInstance) {
        Defense.notNull((Object)panelInstance, (String)"CardPanel cannot be null");
        this.addCardPanel(panelInstance.getClass(), panelInstance);
    }

    @Override
    public void addCardPanel(Class<? extends CardPanel> panelClass, CardPanel panelInstance) {
        panelInstance.setFlipManager(this);
        this.switchSupport.addCardPanel(panelClass, panelInstance);
        this.add((Component)panelInstance, panelClass.getName());
    }

    @Override
    public <T extends CardPanel> T getCardPanel(Class<T> c) {
        return this.switchSupport.getCardPanel(c);
    }

    @Override
    public boolean switchTo(Class<? extends CardPanel> c) {
        if (this.switchSupport.getCurrentCard() == null) {
            return this.switchSupport.switchTo(c, null);
        }
        if (this.switchSupport.getCurrentCard().isAllowedToExit()) {
            return this.switchSupport.switchTo(c, null);
        }
        return false;
    }

    @Override
    public boolean switchTo(Class<? extends CardPanel> c, Object o) {
        if (this.switchSupport.getCurrentCard() == null) {
            return this.switchSupport.switchTo(c, o);
        }
        if (this.switchSupport.getCurrentCard().isAllowedToExit()) {
            return this.switchSupport.switchTo(c, o);
        }
        return false;
    }

    @Override
    public boolean canSwitchTo(Class<? extends CardPanel> c) {
        if (this.switchSupport.getCurrentCard() == null) {
            return this.switchSupport.canSwitchTo(c);
        }
        if (this.switchSupport.getUpcomingCard().isAllowedToExit()) {
            return this.switchSupport.canSwitchTo(c);
        }
        return false;
    }

    @Override
    public boolean isParentVisible() {
        return this.switchSupport.isParentVisible();
    }

    @Override
    public boolean isCardStackEmpty() {
        return this.switchSupport.isCardStackEmpty();
    }

    @Override
    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c) {
        return this.switchSupport.stackCurrentCardAndSwitchTo(c);
    }

    @Override
    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c, Object o) {
        return this.switchSupport.stackCurrentCardAndSwitchTo(c, o);
    }

    @Override
    public void navigateBack() {
        this.switchSupport.navigateBack();
    }

    @Override
    public SwitchSupport getSwitchSupport() {
        return this.switchSupport;
    }

    public boolean isOneOfCardsActive(Iterable<Class<?>> cardPanelTypes) {
        boolean onStack = this.switchSupport.isOneOfCardsOnStack(cardPanelTypes);
        boolean current = ClassUtils.isInstanceOfAny((Object)this.getCurrentCard(), cardPanelTypes);
        return onStack || current;
    }

    @Override
    public void afterExit(CardPanel newCard, boolean stackCurrentCard) {
    }

    @Override
    public void beforeEnter(String name, boolean stackCurrentCard) {
        this.cardLayout.show(this, name);
    }

    @Override
    public void doNavigateBackTo(CardPanel cp) {
        this.switchTo(cp.getClass());
    }

    @Override
    public void addCardChangedListener(CardChangedListener listener) {
        this.switchSupport.addCardChangedListener(listener);
    }

    @Deprecated
    public void removeCardChangedListener(CardChangedListener listener) {
    }
}

