/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.flippable;

import com.ur.swing.CardChangedListener;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.SwingUtil;
import com.ur.swing.SwitchSupport;
import com.ur.swing.flippable.SingleSelectionModelDeniable;
import com.ur.util.logging.Log;
import java.awt.Component;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlippableTabbedPanel
extends JTabbedPane
implements FlipManager,
ChangeListener,
SwitchSupport.Callback {
    private final transient SingleSelectionModelDeniable singleSelectionModelDeniable;
    private final transient SwitchSupport switchSupport;
    private CardPanel invisibleComponentShowing = null;
    private boolean leaveApproved = true;
    private ReentrantLock lock = new ReentrantLock();

    public FlippableTabbedPanel() {
        this.singleSelectionModelDeniable = new SingleSelectionModelDeniable();
        this.switchSupport = new SwitchSupport(this);
        this.setModel(this.singleSelectionModelDeniable);
        this.singleSelectionModelDeniable.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        CardPanel oldCard = this.switchSupport.getCurrentCard();
        if (!this.leaveApproved) {
            return;
        }
        try {
            this.switchSupport.setCurrentCard((CardPanel)this.getSelectedComponent());
        }
        catch (Exception exception) {
            Log.error((String)("There should only be CardPanels in FlippableTabbedPanel tabs. But I found a " + this.getSelectedComponent().getClass().getName()));
        }
        if (this.switchSupport.getCurrentCard() == null) {
            this.switchSupport.setCurrentCard(oldCard);
        } else if (this.switchSupport.getCurrentCard() != oldCard && this.isShowing()) {
            if (oldCard != null) {
                oldCard.exit();
            }
            this.switchSupport.getCurrentCard().enter(null);
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        if (this.switchSupport.getCurrentCard() != null && !this.switchSupport.getCurrentCard().isAllowedToExit()) {
            this.leaveApproved = false;
        } else {
            this.leaveApproved = true;
            if (index >= this.getTabCount()) {
                index = -1;
            }
            if (super.getSelectedIndex() != index) {
                super.setSelectedIndex(index);
                SwitchSupport.notifyOfChange(this.switchSupport.getCurrentCard().getClass(), true);
            }
        }
    }

    @Override
    public CardPanel getCurrentCard() {
        return this.switchSupport.getCurrentCard();
    }

    @Override
    public CardPanel getCardParent() {
        return this.switchSupport.getCardParent();
    }

    @Override
    public void setCardParent(CardPanel cardPanel) {
        this.switchSupport.setCardParent(cardPanel);
        cardPanel.addChild(this);
    }

    @Override
    public void resetAll() {
        this.switchSupport.resetAll();
        this.setMenuItemsEnabled(this.getCurrentCard(), true);
        this.setEnableSelectionMode(true);
        this.setAllTabsEnabled();
        try {
            this.setSelectedIndex(0);
        }
        catch (Exception exception) {
            Log.error((String)"There were no tabs in this FlippableTabbedPane to set as default at reset.");
        }
        if (this.invisibleComponentShowing != null) {
            try {
                this.remove(this.invisibleComponentShowing);
            }
            catch (Exception e) {
                Log.error((String)("Remove failed for some reason. " + e));
            }
            this.invisibleComponentShowing = null;
        }
    }

    @Override
    public boolean canReset() {
        if (this.getCurrentCard() != null && !this.getCurrentCard().isAllowedToExit()) {
            return false;
        }
        return this.switchSupport.canReset();
    }

    @Override
    public void enterActiveChild(Object o) {
        this.switchSupport.enterActiveChild(o);
        SwitchSupport.notifyOfChange(this.switchSupport.getCurrentCard().getClass(), true);
    }

    @Override
    public Object exitActiveChild() {
        return this.switchSupport.exitActiveChild();
    }

    @Override
    public void addCardPanel(CardPanel panelInstance) {
        panelInstance.setFlipManager(this);
        this.addCardPanel(panelInstance.getClass(), panelInstance);
    }

    @Override
    public void addCardPanel(Class<? extends CardPanel> panelClass, CardPanel panelInstance) {
        panelInstance.setFlipManager(this);
        this.addCardPanel(panelInstance, panelClass.getName());
    }

    public void addCardPanel(CardPanel cp, String tabTitle) {
        cp.setFlipManager(this);
        this.switchSupport.addCardPanel(cp.getClass(), cp);
        this.lock.lock();
        try {
            this.addTab(tabTitle, cp);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addCardChangedListener(CardChangedListener listener) {
        this.switchSupport.addCardChangedListener(listener);
    }

    @Deprecated
    public void removeCardChangedListener(CardChangedListener listener) {
    }

    public void addInvisibleCardPanel(CardPanel cp) {
        cp.setFlipManager(this);
        this.switchSupport.addCardPanel(cp.getClass(), cp);
    }

    public void hideCardPanelTab(CardPanel cp) {
        int index = this.indexOfComponent(cp);
        if (index < 0) {
            return;
        }
        this.removeTabAt(index);
    }

    public void showCardPanelTab(CardPanel cp, int indexToAppearAt, String tabTitle) {
        if (!this.isCardVisible(cp)) {
            if (this.switchSupport.hasCardPanelForClass(cp.getClass())) {
                this.insertTab(tabTitle, null, cp, null, indexToAppearAt);
            } else {
                Log.error((String)("FlippableTabbedPane.showCardPanelTab(" + cp.getClass().getName() + ") No such card panel."));
            }
        }
    }

    @Override
    public <T extends CardPanel> T getCardPanel(Class<T> c) {
        return this.switchSupport.getCardPanel(c);
    }

    @Override
    public boolean switchTo(Class<? extends CardPanel> c) {
        return this.switchSupport.switchTo(c);
    }

    @Override
    public boolean switchTo(Class<? extends CardPanel> c, Object o) {
        return this.switchSupport.switchTo(c, o);
    }

    @Override
    public boolean canSwitchTo(Class<? extends CardPanel> c) {
        return this.switchSupport.canSwitchTo(c);
    }

    @Override
    public boolean isParentVisible() {
        return this.switchSupport.isParentVisible();
    }

    @Override
    public boolean isCardStackEmpty() {
        return this.switchSupport.isCardStackEmpty();
    }

    @Override
    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c) {
        return this.switchSupport.stackCurrentCardAndSwitchTo(c);
    }

    @Override
    public boolean stackCurrentCardAndSwitchTo(Class<? extends CardPanel> c, Object o) {
        return this.switchSupport.stackCurrentCardAndSwitchTo(c, o);
    }

    @Override
    public void navigateBack() {
        this.switchSupport.navigateBack();
    }

    @Override
    public SwitchSupport getSwitchSupport() {
        return this.switchSupport;
    }

    @Override
    public void afterExit(CardPanel newCard, boolean stackCurrentCard) {
        if (stackCurrentCard) {
            this.setAllTabsEnabled();
            this.setMenuItemsEnabled(this.getCurrentCard(), true);
            this.setEnableSelectionMode(true);
            int index = this.indexOfComponent(newCard);
            if (index == -1) {
                this.addTab(newCard.getName(), newCard);
                this.invisibleComponentShowing = newCard;
            }
        }
    }

    @Override
    public void beforeEnter(String name, boolean stackCurrentCard) {
        if (stackCurrentCard) {
            this.setSelectedComponent(this.getCurrentCard());
            this.disableAllTabsButOne(this.getCurrentCard());
            this.setMenuItemsEnabled(this.getCurrentCard(), false);
            this.setEnableSelectionMode(false);
        } else {
            try {
                this.setSelectedComponent(this.getCurrentCard());
            }
            catch (Exception exception) {
                this.addTab(this.getCurrentCard().getName(), this.getCurrentCard());
                this.invisibleComponentShowing = this.getCurrentCard();
                this.setSelectedComponent(this.getCurrentCard());
            }
        }
    }

    @Override
    public void doNavigateBackTo(CardPanel cp) {
        this.setEnableSelectionMode(true);
        this.setMenuItemsEnabled(this.getCurrentCard(), true);
        this.setAllTabsEnabled();
        if (this.invisibleComponentShowing == this.getCurrentCard() && this.getCurrentCard() != null) {
            this.switchTo(cp.getClass());
            try {
                this.remove(this.invisibleComponentShowing);
            }
            catch (Exception e) {
                Log.error((String)("Remove failed for some reason. " + e));
            }
            this.invisibleComponentShowing = null;
        } else {
            this.switchTo(cp.getClass());
        }
        if (!this.switchSupport.isCardStackEmpty()) {
            this.disableAllTabsButOne(this.getCurrentCard());
            this.setMenuItemsEnabled(this.getCurrentCard(), false);
            this.setEnableSelectionMode(false);
        }
    }

    private void setEnableSelectionMode(boolean enabledState) {
        this.singleSelectionModelDeniable.setDenied(!enabledState);
    }

    private void setAllTabsEnabled() {
        int i = 0;
        while (i < this.getTabCount()) {
            this.setEnabledAt(i, true);
            ++i;
        }
    }

    private void disableAllTabsButOne(CardPanel cardPanel) {
        int index = this.indexOfComponent(cardPanel);
        int i = 0;
        while (i < this.getTabCount()) {
            if (i != index) {
                this.setEnabledAt(i, false);
            }
            ++i;
        }
    }

    private void setMenuItemsEnabled(JComponent component, boolean enableState) {
        JFrame frame = SwingUtil.getJFrameFor(component);
        if (frame != null) {
            for (Component eachMenuItem : SwingUtil.getAllComponents(frame, JMenuItem.class)) {
                eachMenuItem.setEnabled(enableState);
            }
        }
    }

    private boolean isCardVisible(CardPanel card) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component == card) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

