/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CardBorder
implements Border {
    private String title;
    private Icon icon;

    public CardBorder(String title) {
        this(null, title);
    }

    public CardBorder(Icon icon, String title) {
        this.icon = icon;
        this.title = title;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        int height = 32;
        return new Insets(height, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int i3) {
        graphics.setFont(UIManager.getFont("TitledBorder.font"));
        graphics.setColor(UIManager.getColor("CardBorder.background"));
        graphics.fillRect(x, y, width, 32);
        graphics.setColor(UIManager.getColor("CardBorder.foreground"));
        if (this.icon == null) {
            int titleAlignmentX = x + 5;
            int titleAlignmentY = y + 22;
            graphics.drawString(this.title, titleAlignmentX, titleAlignmentY);
        } else {
            this.icon.paintIcon(component, graphics, x + 5, y + 5);
            graphics.drawString(this.title, x + 10 + this.icon.getIconWidth(), y + 22);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }
}

