/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.DefaultComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;

public final class ComboBoxRenderer {
    private static final Color DEFAULT_BACKGROUND = UIManager.getColor("ComboBox.background");
    private static final Color DEFAULT_SELECTED_BACKGROUND = UIManager.getColor("ComboBox.selectionBackground");
    private static final Color UNDEFINED_WARNING_COLOR = UIManager.getColor("undefined.warning");
    private final Border errorBorder;
    private final DefaultComboBoxRenderer renderingStrategy;

    private ComboBoxRenderer(JComboBox comboBox, DefaultComboBoxRenderer renderingStrategy) {
        this.errorBorder = this.getErrorBorder(comboBox);
        this.renderingStrategy = renderingStrategy;
        comboBox.setRenderer(new ComboBoxCellRenderer());
        comboBox.addActionListener(new ItemStateListener());
        comboBox.addPropertyChangeListener("model", new ModelChangeListener());
    }

    private void updateSource(Object source) {
        if (source instanceof JComboBox) {
            JComboBox comboBox = (JComboBox)source;
            Object selectedItem = comboBox.getSelectedItem();
            if (selectedItem != null && this.renderingStrategy.hasError(selectedItem)) {
                comboBox.setFont(comboBox.getFont().deriveFont(2));
                comboBox.setBorder(this.errorBorder);
            } else {
                comboBox.setFont(comboBox.getFont().deriveFont(0));
                comboBox.setBorder(UIManager.getBorder("ComboBox.border"));
            }
        }
    }

    private Border getErrorBorder(JComboBox comboBox) {
        Border spaceAroundOriginalBorder = this.getFillerBetweenOriginalBorderAndWarningBorder(comboBox);
        return new CompoundBorder(new LineBorder(UNDEFINED_WARNING_COLOR, 2), spaceAroundOriginalBorder);
    }

    private Border getFillerBetweenOriginalBorderAndWarningBorder(JComboBox comboBox) {
        Border fillerBorder = this.getFillerBorder();
        if (comboBox.getBorder() == null) {
            return fillerBorder;
        }
        Border originalBorder = comboBox.getBorder();
        return new CompoundBorder(fillerBorder, originalBorder);
    }

    private Border getFillerBorder() {
        return BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public static void bindRenderer(JComboBox comboBox, DefaultComboBoxRenderer renderingStrategy) {
        new ComboBoxRenderer(comboBox, renderingStrategy);
    }

    public static void unbindRenderer(JComboBox comboBox) {
        EventListener each;
        EventListener[] eventListenerArray = comboBox.getActionListeners();
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            each = eventListenerArray[n2];
            if (each instanceof ItemStateListener) {
                comboBox.removeActionListener((ActionListener)each);
            }
            ++n2;
        }
        eventListenerArray = comboBox.getPropertyChangeListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            each = eventListenerArray[n2];
            if (each instanceof ModelChangeListener) {
                comboBox.removePropertyChangeListener((PropertyChangeListener)each);
            }
            ++n2;
        }
    }

    private class ComboBoxCellRenderer
    extends DefaultComboBoxRenderer {
        public ComboBoxCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setOpaque(true);
            if (ComboBoxRenderer.this.renderingStrategy.hasError(value) && this.countItemsIn(list) > 0) {
                this.setFont(this.getFont().deriveFont(2));
                this.setBackground(UNDEFINED_WARNING_COLOR);
            } else if (isSelected) {
                this.setBackground(DEFAULT_SELECTED_BACKGROUND);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setBackground(DEFAULT_BACKGROUND);
            }
            return this;
        }

        private int countItemsIn(JList list) {
            return list.getModel().getSize();
        }
    }

    private class ItemStateListener
    implements ActionListener {
        private ItemStateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ComboBoxRenderer.this.updateSource(event.getSource());
        }
    }

    private class ModelChangeListener
    implements PropertyChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ComboBoxRenderer.this.updateSource(event.getSource());
        }
    }
}

