/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.ComboBoxRenderer;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class ComboBoxUI
extends BasicComboBoxUI {
    public static final int MAXIMUM_ROW_COUNT = 20;

    public static ComponentUI createUI(JComponent c) {
        ((JComboBox)c).setMaximumRowCount(20);
        ComboBoxRenderer.bindRenderer((JComboBox)c, new DefaultComboBoxRenderer());
        return new ComboBoxUI();
    }

    @Override
    protected JButton createArrowButton() {
        JButton button = super.createArrowButton();
        button.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        button.setFocusable(false);
        button.setRolloverEnabled(false);
        return button;
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        c.setFont(this.comboBox.getFont());
        c.setForeground(this.comboBox.isEnabled() ? Color.BLACK : Color.LIGHT_GRAY);
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        this.currentValuePane.paintComponent(g, c, this.comboBox, x, y, w, h, shouldValidate);
    }

    @Override
    protected ComboPopup createPopup() {
        return new BasicComboPopup(this.comboBox){
            private RobustComboPopupMouseListener mouseListener;

            @Override
            protected MouseListener createMouseListener() {
                if (this.mouseListener == null) {
                    this.mouseListener = new RobustComboPopupMouseListener();
                }
                return this.mouseListener;
            }

            class RobustComboPopupMouseListener
            extends MouseAdapter {
                RobustComboPopupMouseListener() {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getSource() == list) {
                        return;
                    }
                    if (!SwingUtilities.isLeftMouseButton(e) || !comboBox.isEnabled()) {
                        return;
                    }
                    if (comboBox.isEditable()) {
                        Component comp = comboBox.getEditor().getEditorComponent();
                        if (!(comp instanceof JComponent) || ((JComponent)comp).isRequestFocusEnabled()) {
                            comp.requestFocus();
                        }
                    } else if (comboBox.isRequestFocusEnabled()) {
                        comboBox.requestFocus();
                    }
                    Component source = (Component)e.getSource();
                    Dimension size = source.getSize();
                    Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                    if (bounds.contains(e.getPoint())) {
                        this.togglePopup();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getSource() == list) {
                        if (list.getModel().getSize() > 0) {
                            if (comboBox.getSelectedIndex() != list.getSelectedIndex()) {
                                comboBox.setSelectedIndex(list.getSelectedIndex());
                            } else {
                                comboBox.getEditor().setItem(list.getSelectedValue());
                            }
                        }
                        comboBox.setPopupVisible(false);
                        if (comboBox.isEditable() && comboBox.getEditor() != null) {
                            comboBox.configureEditor(comboBox.getEditor(), comboBox.getSelectedItem());
                        }
                        return;
                    }
                    Component source = (Component)e.getSource();
                    Dimension size = source.getSize();
                    Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                    if (!bounds.contains(e.getPoint())) {
                        MouseEvent newEvent = this.convertMouseEvent(e);
                        Point location = newEvent.getPoint();
                        Rectangle r = new Rectangle();
                        list.computeVisibleRect(r);
                        if (r.contains(location)) {
                            if (comboBox.getSelectedIndex() != list.getSelectedIndex()) {
                                comboBox.setSelectedIndex(list.getSelectedIndex());
                            } else {
                                comboBox.getEditor().setItem(list.getSelectedValue());
                            }
                        }
                        comboBox.setPopupVisible(false);
                    }
                    hasEntered = false;
                    this.stopAutoScrolling();
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (e.getSource() == list) {
                        Point location = e.getPoint();
                        Rectangle rect = new Rectangle();
                        list.computeVisibleRect(rect);
                        if (rect.contains(location)) {
                            this.updateListBoxSelectionForEvent(e, false);
                        }
                    }
                }
            }
        };
    }
}

