/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.renderers.ElementCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

public class DefaultComboBoxRenderer
extends DefaultListCellRenderer {
    public static final int MAX_HEIGHT = UIManager.getInt("ComboBox.cellHeight");
    private static final Color UNDEFINED_WARNING = UIManager.getColor("undefined.warning");
    private static final Color SELECTED_BACKGROUND = UIManager.getColor("ComboBox.selectionBackground");
    private static final Color DEFAULT_BACKGROUND = UIManager.getColor("ComboBox.background");
    private static final ElementCellRenderer defaultRenderer = new DoNothingElementCellRenderer();
    private static List<ElementCellRenderer> rendererList = new ArrayList<ElementCellRenderer>();

    public static void setRendererList(Set<ElementCellRenderer> rendererList) {
        DefaultComboBoxRenderer.rendererList = new ArrayList<ElementCellRenderer>(rendererList);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        ElementCellRenderer renderer = this.getElementCellRenderer(value);
        renderer.renderElement((JLabel)result, list, value);
        if (renderer.hasError(value) && this.hasItems(list)) {
            this.setFont(this.getFont().deriveFont(2));
            this.setBackground(UNDEFINED_WARNING);
        } else if (isSelected) {
            this.setBackground(SELECTED_BACKGROUND);
        } else {
            this.setFont(this.getFont().deriveFont(0));
            this.setBackground(DEFAULT_BACKGROUND);
        }
        Dimension dim = super.getSize();
        dim.width = Math.max(dim.width, this.getPreferredSize().width);
        dim.height = MAX_HEIGHT;
        result.setPreferredSize(dim);
        return result;
    }

    boolean hasError(Object o) {
        return this.getElementCellRenderer(o).hasError(o);
    }

    private boolean hasItems(JList list) {
        return list.getModel().getSize() > 0;
    }

    ElementCellRenderer getElementCellRenderer(Object value) {
        for (ElementCellRenderer each : rendererList) {
            if (!each.supportsType(value)) continue;
            return each;
        }
        return defaultRenderer;
    }

    private static class DoNothingElementCellRenderer
    implements ElementCellRenderer {
        private DoNothingElementCellRenderer() {
        }

        @Override
        public boolean supportsType(Object value) {
            return true;
        }

        public void renderElement(JLabel result, JList list, Object value) {
        }

        public boolean hasError(Object value) {
            return false;
        }
    }
}

