/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class DialogBorder
implements Border {
    public static final int TEXT_HEIGHT = 32;
    private int OUTER_MATTE_BORDER = 40;
    private Color BACKGROUND = new Color(179, 179, 179);
    private final String title;

    public DialogBorder(String title, Color background) {
        this.title = title;
        this.BACKGROUND = background;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        int height = 32 + this.OUTER_MATTE_BORDER;
        return new Insets(height, this.OUTER_MATTE_BORDER + 5, this.OUTER_MATTE_BORDER + 5, this.OUTER_MATTE_BORDER + 5);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        graphics.setFont(UIManager.getFont("TitledBorder.font"));
        graphics.setColor(G5LookAndFeel.BETWEEN_CARD_COLOR);
        graphics.fillRect(x, y, width, this.OUTER_MATTE_BORDER);
        graphics.fillRect(x, y, this.OUTER_MATTE_BORDER, height);
        graphics.fillRect(x, y + height - this.OUTER_MATTE_BORDER, width, this.OUTER_MATTE_BORDER);
        graphics.fillRect(x + width - this.OUTER_MATTE_BORDER, y, this.OUTER_MATTE_BORDER, height);
        graphics.setColor(this.BACKGROUND);
        graphics.fillRect(x + this.OUTER_MATTE_BORDER, y + this.OUTER_MATTE_BORDER, width - this.OUTER_MATTE_BORDER * 2, 32);
        graphics.fillRect(x + this.OUTER_MATTE_BORDER, y + this.OUTER_MATTE_BORDER, 5, height - this.OUTER_MATTE_BORDER * 2);
        graphics.fillRect(x + this.OUTER_MATTE_BORDER, height - this.OUTER_MATTE_BORDER - 5, width - this.OUTER_MATTE_BORDER * 2, 5);
        graphics.fillRect(x + width - this.OUTER_MATTE_BORDER - 5, y + this.OUTER_MATTE_BORDER, 5, height - this.OUTER_MATTE_BORDER * 2);
        graphics.setColor(Color.BLACK);
        int textWidth = this.getWidthOfTitleFromFont(graphics);
        int titleAlignmentX = width / 2 - textWidth / 2;
        int titileAlignmentY = y + 22 + this.OUTER_MATTE_BORDER;
        graphics.drawString(this.title, titleAlignmentX, titileAlignmentY);
    }

    private int getWidthOfTitleFromFont(Graphics graphics) {
        Object antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
        Object fractionalmetricsHint = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
        FontRenderContext fontRenderContext = new FontRenderContext(null, antiAliasHint, fractionalmetricsHint);
        return (int)graphics.getFont().getStringBounds(this.title, fontRenderContext).getWidth();
    }
}

