/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.DualValueSlider;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSliderUI;

public class DualSliderUI
extends MetalSliderUI {
    private static final Color FILL_COLOR = UIManager.getColor("Slider.trackColor");
    private static final Color OUTLINE_COLOR = G5LookAndFeel.COMPONENT_BACKGROUND;
    private static final int INDICATOR_THICKNESS = 3;
    private static final int THUMB_TO_TRACK_BAR = 5;
    protected Icon disableVertThumbIcon;
    protected Icon disableHorizThumbIcon;

    public static ComponentUI createUI(JComponent component) {
        DualValueSlider slider = (DualValueSlider)component;
        slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        return new DualSliderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.disableHorizThumbIcon = UIManager.getIcon("Slider.disabledHorizontalThumbIcon");
        if (this.disableHorizThumbIcon == null) {
            this.disableHorizThumbIcon = MetalSliderUI.horizThumbIcon;
        }
        this.disableVertThumbIcon = UIManager.getIcon("Slider.disabledVerticalThumbIcon");
        if (this.disableVertThumbIcon == null) {
            this.disableHorizThumbIcon = MetalSliderUI.vertThumbIcon;
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        this.paintIndicator(g);
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.getOrientation() == 0) {
            Icon hIcon = this.slider.isEnabled() ? MetalSliderUI.horizThumbIcon : this.disableHorizThumbIcon;
            hIcon.paintIcon(this.slider, g, 0, -2);
        } else {
            Icon vIcon = this.slider.isEnabled() ? MetalSliderUI.vertThumbIcon : this.disableVertThumbIcon;
            vIcon.paintIcon(this.slider, g, 0, -2);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    @Override
    public void setThumbLocation(int x, int y) {
        DualValueSlider slider = (DualValueSlider)this.slider;
        if (slider.getOrientation() == 0) {
            int thumbMiddle = x + this.thumbRect.width / 2;
            if (slider.exceedsLimit(this.valueForXPosition(thumbMiddle))) {
                x = this.xThumbPositionForValue(slider.getUpperLimit());
            }
        } else {
            int thumbMiddle = y + this.thumbRect.height / 2;
            if (slider.exceedsLimit(this.valueForYPosition(thumbMiddle))) {
                y = this.yThumbPositionForValue(slider.getUpperLimit());
            }
        }
        super.setThumbLocation(x, y);
    }

    private int xThumbPositionForValue(int value) {
        return this.xPositionForValue(value) - this.thumbRect.width / 2;
    }

    private int yThumbPositionForValue(int value) {
        return this.yPositionForValue(value) - this.thumbRect.height / 2;
    }

    private void paintIndicator(Graphics g) {
        DualValueSlider slider = (DualValueSlider)this.slider;
        int trackTop = this.getTrackWidth() - 2;
        int trackThickness = 7;
        if (slider.getOrientation() == 0) {
            int indicatorStart;
            if (slider.isIndicatorVisible()) {
                g.setColor(slider.getIndicatorColor());
                indicatorStart = this.xThumbPositionForValue(slider.getIndicatorValue()) - 1;
                g.fillRect(this.trackRect.x + indicatorStart, this.thumbRect.y, 3, this.thumbRect.height - 2);
                g.fillRect(this.trackRect.x, trackTop, indicatorStart, trackThickness);
            }
            if (slider.hasUpperLimit()) {
                g.setColor(slider.getUpperLimitColor());
                indicatorStart = this.xThumbPositionForValue(slider.getUpperLimit()) - 1;
                int fillerStart = indicatorStart + 3;
                g.fillRect(this.trackRect.x + indicatorStart, this.thumbRect.y, 3, this.thumbRect.height - 2);
                g.fillRect(this.trackRect.x + fillerStart, trackTop, this.xThumbPositionForValue(slider.getMaximum()) - fillerStart - 4, trackThickness);
                g.fillArc(this.trackRect.x + indicatorStart + this.xThumbPositionForValue(slider.getMaximum()) - fillerStart - 5, trackTop, 8, 7, 90, -180);
            }
        } else {
            int indicatorStart;
            if (slider.isIndicatorVisible()) {
                g.setColor(slider.getIndicatorColor());
                indicatorStart = this.yThumbPositionForValue(slider.getIndicatorValue()) - 1;
                int fillerStart = indicatorStart + 3;
                g.fillRect(this.thumbRect.x, this.trackRect.y + indicatorStart, this.thumbRect.width, 3);
                g.fillRect(this.trackRect.x + 5, this.trackRect.y + fillerStart, this.trackRect.width - 10, this.yThumbPositionForValue(0) - fillerStart);
            }
            if (slider.hasUpperLimit()) {
                g.setColor(slider.getUpperLimitColor());
                indicatorStart = this.yThumbPositionForValue(slider.getUpperLimit()) - 1;
                g.fillRect(this.thumbRect.x, this.trackRect.y + indicatorStart, this.thumbRect.width, 3);
                g.fillRect(this.trackRect.x + 5, this.trackRect.y, this.trackRect.width - 10, indicatorStart);
            }
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        Color outlineColor;
        this.slider.isEnabled();
        MetalLookAndFeel.getControlShadow();
        this.slider.getForeground();
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        Color color = outlineColor = this.slider.isEnabled() ? OUTLINE_COLOR : G5LookAndFeel.DISABLED_BACKGROUND;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - this.getTrackWidth();
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        g.setColor(outlineColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawArc(trackLeft - 1, trackTop - 2, 12, 12, 90, 180);
        g.drawLine(trackLeft + 5, trackTop - 2, trackRight - 5, trackTop - 2);
        g.drawLine(trackLeft + 5, trackBottom, trackRight - 5, trackBottom);
        g.drawArc(trackRight - 10, trackTop - 2, 12, 12, 90, -180);
        if (this.filledSlider) {
            Color fillColor;
            int middleOfThumb = 0;
            int fillTop = 0;
            int fillLeft = 0;
            int fillBottom = 0;
            int fillRight = 0;
            Color color2 = fillColor = this.slider.isEnabled() ? FILL_COLOR : G5LookAndFeel.DISABLED_BACKGROUND;
            if (this.slider.getOrientation() == 0) {
                middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
                middleOfThumb -= this.trackRect.x;
                fillTop = trackTop + 1;
                fillBottom = trackBottom - 2;
                if (!this.drawInverted()) {
                    fillLeft = trackLeft + 1;
                    fillRight = middleOfThumb;
                } else {
                    fillLeft = middleOfThumb;
                    fillRight = trackRight - 2;
                }
            } else {
                middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
                middleOfThumb -= this.trackRect.y;
                fillLeft = trackLeft + 1;
                fillRight = trackRight - 2;
                if (!this.drawInverted()) {
                    fillTop = middleOfThumb;
                    fillBottom = trackBottom - 2;
                } else {
                    fillTop = trackTop + 1;
                    fillBottom = middleOfThumb;
                }
            }
            g.setColor(fillColor);
            g.fillOval(trackLeft + 2, trackTop + 1, 7, 7);
            g.fillRect(fillLeft + 6, fillTop, fillRight - fillLeft - 6, fillBottom - fillTop);
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }
}

