/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import java.awt.Color;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class DualValueProgressBar
extends JProgressBar {
    public static final String INDICATOR_COLOR = "DualValueSlider.indicatorColor";
    public static final String UPPER_LIMIT_COLOR = "DualValueSlider.upperLimitColor";
    private static final String UI_CLASS_ID = "DualValueProgressBarUI";
    private static final int NO_UPPER_LIMIT = -1;
    private int indicatorValue;
    private boolean indicatorVisible = false;
    private Color indicatorColor = UIManager.getColor("DualValueSlider.indicatorColor");
    private int upperLimit = -1;
    private Color upperLimitColor = UIManager.getColor("DualValueSlider.upperLimitColor");

    public DualValueProgressBar() {
        this(0);
    }

    public DualValueProgressBar(int orientation) {
        super(orientation);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void setValue(int value) {
        super.setValue(this.clampToLimit(value));
    }

    public void setIndicatorValue(int value) {
        this.indicatorValue = value;
    }

    public int getIndicatorValue() {
        return this.indicatorValue;
    }

    public void setIndicatorColor(Color indicatorColor) {
        this.indicatorColor = indicatorColor;
    }

    public Color getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorVisible(boolean indicatorVisible) {
        this.indicatorVisible = indicatorVisible;
    }

    public boolean isIndicatorVisible() {
        return this.indicatorVisible;
    }

    public void setUpperLimit(int upperLimit) {
        if (upperLimit >= this.getMaximum() || upperLimit < -1) {
            upperLimit = -1;
        }
        this.upperLimit = upperLimit;
        this.setValue(this.getValue());
    }

    public boolean hasUpperLimit() {
        return this.upperLimit >= 0 && this.upperLimit < this.getMaximum();
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimitColor(Color upperLimitColor) {
        this.upperLimitColor = upperLimitColor;
    }

    private int clampToLimit(int value) {
        return this.exceedsLimit(value) ? this.upperLimit : value;
    }

    public boolean exceedsLimit(int value) {
        return this.hasUpperLimit() && value > this.upperLimit;
    }

    public double getUpperLimitPercentComplete() {
        long range = this.model.getMaximum() - this.model.getMinimum();
        double upperLimit = this.getUpperLimit();
        return (upperLimit - (double)this.model.getMinimum()) / (double)range;
    }
}

