/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.DualValueProgressBar;
import com.ur.swing.g5.URProgressBarUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class DualValueProgressBarUI
extends URProgressBarUI {
    public static ComponentUI createUI(JComponent component) {
        return new DualValueProgressBarUI();
    }

    protected int getUpperLimitAmountFull(Insets insets, int width, int height) {
        int limit = 0;
        BoundedRangeModel model = this.progressBar.getModel();
        if (model.getMaximum() - model.getMinimum() != 0) {
            limit = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)width * ((DualValueProgressBar)this.progressBar).getUpperLimitPercentComplete()) : (int)Math.round((double)height * ((DualValueProgressBar)this.progressBar).getPercentComplete());
        }
        return limit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        int upperLimitAmountFull = this.getUpperLimitAmountFull(b, barRectWidth, barRectHeight);
        if (this.progressBar.getOrientation() == 0) {
            if (!c.getComponentOrientation().isLeftToRight()) throw new RuntimeException("Not implemented yet!!");
            int sphereSize = barRectHeight;
            g2.setColor(UIManager.getColor("ProgressBar.fillColor"));
            g2.fillRoundRect(b.left, b.top, barRectWidth + 1, barRectHeight, sphereSize, sphereSize);
            Shape clip = g2.getClip();
            g2.setClip(DualValueProgressBarUI.calculateIntersectionClip(b.left, b.top, amountFull, barRectHeight, clip));
            g2.setColor(this.progressBar.getForeground());
            g2.fillRoundRect(b.left + 1, b.top + 1, barRectWidth - 1, barRectHeight - 1, sphereSize - 1, sphereSize - 1);
            g2.setClip(clip);
            g2.setColor(Color.RED);
            g2.fillRect(upperLimitAmountFull, b.top, 3, barRectHeight);
        } else {
            int sphereSize = barRectWidth;
            g2.setColor(UIManager.getColor("ProgressBar.fillColor"));
            g2.fillRoundRect(b.left, b.top, barRectWidth + 1, barRectHeight + 1, sphereSize, sphereSize);
            Shape clip = g2.getClip();
            g2.setClip(DualValueProgressBarUI.calculateIntersectionClip(b.left + 1, barRectHeight - amountFull + b.top, barRectWidth - 1, barRectHeight, clip));
            g2.setColor(this.progressBar.getForeground());
            g2.fillRoundRect(b.left + 1, b.top + 1, barRectWidth - 1, barRectHeight - 1, sphereSize - 1, sphereSize - 1);
            g2.setClip(clip);
        }
        if (!this.progressBar.isStringPainted()) return;
        this.paintString(g, b.left, b.top + 1, barRectWidth, barRectHeight, amountFull, b);
    }
}

