/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.DualSliderUI;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JSlider;
import javax.swing.UIManager;

public class DualValueSlider
extends JSlider {
    public static final String INDICATOR_COLOR_UI_KEY = "DualValueSlider.indicatorColor";
    public static final String UPPER_LIMIT_COLOR_UI_KEY = "DualValueSlider.upperLimitColor";
    public static final String UI_CLASS_ID = "DualValueSliderUI";
    private static final int NO_UPPER_LIMIT = -1;
    private int indicatorValue;
    private boolean indicatorVisible = false;
    private Color indicatorColor = UIManager.getColor("DualValueSlider.indicatorColor");
    private int upperLimit = -1;
    private Color upperLimitColor = UIManager.getColor("DualValueSlider.upperLimitColor");

    public DualValueSlider() {
        this(0);
    }

    public DualValueSlider(int orientation) {
        super(orientation);
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    @Override
    public void setValue(int value) {
        super.setValue(this.clampToLimit(value));
    }

    public void setIndicatorValue(int value) {
        this.indicatorValue = value;
    }

    public int getIndicatorValue() {
        return this.indicatorValue;
    }

    public void setIndicatorColor(Color indicatorColor) {
        this.indicatorColor = indicatorColor;
    }

    public void setIndicatorVisible(boolean indicatorVisible) {
        this.indicatorVisible = indicatorVisible;
    }

    public boolean isIndicatorVisible() {
        return this.indicatorVisible;
    }

    public void setUpperLimit(int upperLimit) {
        if (upperLimit >= this.getMaximum() || upperLimit < -1) {
            upperLimit = -1;
        }
        this.upperLimit = upperLimit;
        this.setValue(this.getValue());
    }

    public boolean hasUpperLimit() {
        return this.upperLimit >= 0 && this.upperLimit < this.getMaximum();
    }

    public int getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimitColor(Color upperLimitColor) {
        this.upperLimitColor = upperLimitColor;
    }

    private int clampToLimit(int value) {
        return this.exceedsLimit(value) ? this.upperLimit : value;
    }

    public boolean exceedsLimit(int value) {
        return this.hasUpperLimit() && value > this.upperLimit;
    }

    @Override
    public void updateUI() {
        this.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.setUI((DualSliderUI)UIManager.getUI(this));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DualValueSlider.this.isEnabled()) {
                    if (DualValueSlider.this.getOrientation() == 0) {
                        DualValueSlider.this.setValue(DualValueSlider.this.getUI().valueForXPosition(e.getX()));
                    } else {
                        DualValueSlider.this.setValue(DualValueSlider.this.getUI().valueForYPosition(e.getY()));
                    }
                }
            }
        });
        this.updateLabelUIs();
    }

    @Override
    public DualSliderUI getUI() {
        return (DualSliderUI)super.getUI();
    }

    public Color getIndicatorColor() {
        return this.indicatorColor;
    }

    public Color getUpperLimitColor() {
        return this.upperLimitColor;
    }
}

