/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.ErrorBorder;
import com.ur.swing.StateBasedBorder;
import com.ur.swing.URFontFactory;
import com.ur.swing.g5.ComboBoxUI;
import com.ur.swing.g5.DualSliderUI;
import com.ur.swing.g5.DualValueProgressBarUI;
import com.ur.swing.g5.EnablementMatteBorder;
import com.ur.swing.g5.OnOffSwitchUI;
import com.ur.swing.g5.OnOffSwitchUIGray;
import com.ur.swing.g5.RoundedEndsLineBorder;
import com.ur.swing.g5.URProgressBarUI;
import com.ur.swing.g5.URRadioButtonUI;
import com.ur.swing.g5.URScrollBarUI;
import com.ur.swing.g5.URSliderUI;
import com.ur.swing.g5.URTabbedPaneUI;
import com.ur.swing.g5.UncheckedCheckedIcon;
import com.ur.swing.resources.ButtonImageResource;
import com.ur.swing.resources.ImageResource;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.help.plaf.basic.BasicContentViewerUI;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class G5LookAndFeel
extends MetalLookAndFeel {
    public static final String FOOTER_BACKGROUND_COLOR_UI_KEY = "footer.background.color";
    public static final String HEADER_BACKGROUND_UI_KEY = "header.background";
    public static final String CHECKSUM_FOREGROUND_UI_KEY = "checksum.foreground";
    public static final String ERROR_COLOR_UI_KEY = "ErrorColor";
    public static final String WARNING_COLOR_UI_KEY = "WarningColor";
    public static final String SLIDER_TRACK_FILL_COLOR_UI_KEY = "Slider.trackColor";
    public static final Color UNIVERSAL_ROBOTS_DARK_BLUE = new Color(86, 160, 211);
    public static final Color UNIVERSAL_ROBOTS_BLUE = new Color(194, 225, 246);
    public static final Color DARK_DARK_GRAY = new Color(51, 51, 51);
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Color HEADER_BACKGROUND = DARK_DARK_GRAY;
    public static final Color SELECTED_HEADER_BACKGROUND = UNIVERSAL_ROBOTS_DARK_BLUE;
    public static final Color FOOTER_BACKGROUND = HEADER_BACKGROUND;
    public static final Color ADD_NODE_STRUCTURE = Color.WHITE;
    public static final Color EDIT_PROGRAM_TREE = Color.WHITE;
    public static final Color BETWEEN_CARD_COLOR = new Color(230, 230, 230);
    public static final Color DISABLED_BACKGROUND = new Color(179, 179, 179);
    public static final Color RUN_GREEN_FOREGROUND = new Color(0, 146, 69);
    public static final Color DISABLED_FOREGROUND = Color.LIGHT_GRAY;
    public static final Color UNDEFINED_WARNING_COLOR = new Color(230, 206, 76);
    public static final Color PRESSED_CONTROL = new Color(243, 243, 243);
    public static final Color INCOMPLETE_BACKGROUND_COLOR = new Color(255, 255, 112);
    public static final Color INCOMPLETE_BORDER_COLOR = new Color(235, 202, 132);
    private static final Color G5_WHITE = Color.WHITE;
    private static final Color G5_BLACK = Color.BLACK;
    private static final Color G5_DARK_BLUE = UNIVERSAL_ROBOTS_DARK_BLUE;
    private static final Color G5_BLUE = UNIVERSAL_ROBOTS_BLUE;
    static final Color COMPONENT_BACKGROUND = Color.LIGHT_GRAY;
    private static final Border TEXT_FIELD_BORDER = new CompoundBorder(new LineBorder(Color.LIGHT_GRAY, 1), new EmptyBorder(4, 4, 4, 4));
    private static final Border TEXT_FIELD_ENABLED_BORDER = new CompoundBorder(new LineBorder(new Color(128, 128, 128), 1), new EmptyBorder(4, 4, 4, 4));
    private static final Border NUMBER_PICKER_TEXT_FIELD_SELECTED_BORDER = new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1), new MatteBorder(4, 4, 4, 4, Color.LIGHT_GRAY));
    private static final Border LIST_BORDER = new LineBorder(Color.LIGHT_GRAY, 1, false);
    private static final String[] COMPONENT_KEYS = new String[]{"ArrowButton", "CheckBox", "CheckBoxMenuItem", "ColorChooser", "ComboBox", "DesktopPane", "DesktopIcon", "EditorPane", "FileChooser", "FormattedTextField", "InternalFrame", "InternalFrameTitlePane", "Label", "List", "OptionPane", "Panel", "PasswordField", "PopupMenu", "PopupMenuSeparator", "ProgressBar", "RadioButton", "RadioButtonMenuItem", "RootPane", "ScrollBar", "ScrollBarTrack", "ScrollBarThumb", "ScrollPane", "Separator", "Slider", "SliderTrack", "SliderThumb", "Spinner", "SplitPane", "TabbedPane", "Table", "TableHeader", "TextArea", "TextField", "TextPane", "ToolBar", "ToolTip", "Tree", "Viewport"};
    private static final String[] BOLD_COMPONENTS = new String[]{"InstallationContributionTitle", "TitledBorder", "Button", "ToggleButton", "Menu", "MenuBar", "TabbedPane", "Header"};
    public static final Color ERROR_FILL_COLOR = new Color(255, 153, 153);
    public static final Color ERROR_BORDER_COLOR = new Color(255, 0, 0);
    public static final Color WARNING_FILL_COLOR = new Color(255, 255, 112);
    public static final Color WARNING_BORDER_COLOR = new Color(204, 168, 99);
    public static final Color INFO_FILL_COLOR = UNIVERSAL_ROBOTS_BLUE;
    public static final Color INFO_BORDER_COLOR = UNIVERSAL_ROBOTS_DARK_BLUE;
    public static final int NUMBER_PICKER_BORDER_THICKNESS = 15;
    public static final String PANEL_BACKGROUND = "Panel.background";
    private final transient URFontFactory fontFactory;

    public G5LookAndFeel(URFontFactory fontFactory) {
        this.fontFactory = fontFactory;
    }

    @Override
    public UIDefaults getDefaults() {
        MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        UIDefaults uiDefaults = super.getDefaults();
        this.initializeDefaultFonts(uiDefaults);
        this.initializeLayout(uiDefaults);
        this.initializeDefaultWidgets(uiDefaults);
        G5LookAndFeel.initializeDefaultRobotAppearance(uiDefaults);
        uiDefaults.put("tool.icon.width", (Object)32);
        uiDefaults.put("ClassLoader", G5LookAndFeel.class.getClassLoader());
        uiDefaults.put("DigitalNamedIO.dimensions", new Dimension(131, 32));
        uiDefaults.put("AboutPane.dimensions", new Dimension(650, 400));
        uiDefaults.put("RadioButtonIconSpacing", (Object)22);
        uiDefaults.put("Form.indentSize", (Object)25);
        return uiDefaults;
    }

    private void initializeLayout(UIDefaults uiDefaults) {
        uiDefaults.put("CardPanel.background", BETWEEN_CARD_COLOR);
        uiDefaults.put("CardPanel.space", (Object)5);
    }

    private void initializeDefaultFonts(UIDefaults uiDefaults) {
        String each;
        FontUIResource defaultFont = this.fontFactory.getDefaultFontResource();
        FontUIResource largeFont = new FontUIResource(this.fontFactory.getRelativeFont(URFontFactory.Size.LARGE));
        FontUIResource defaultBoldFont = new FontUIResource(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD));
        FontUIResource smallerBoldFont = new FontUIResource(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.SMALL));
        FontUIResource largeBoldFont = new FontUIResource(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
        String[] stringArray = COMPONENT_KEYS;
        int n = COMPONENT_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            each = stringArray[n2];
            uiDefaults.put(String.valueOf(each) + ".font", defaultFont);
            ++n2;
        }
        stringArray = BOLD_COMPONENTS;
        n = BOLD_COMPONENTS.length;
        n2 = 0;
        while (n2 < n) {
            each = stringArray[n2];
            uiDefaults.put(String.valueOf(each) + ".font", defaultBoldFont);
            ++n2;
        }
        uiDefaults.put("PasswordField.font", largeFont);
        uiDefaults.put("TextField.font", largeFont);
        uiDefaults.put("TreeHeader.font", largeBoldFont);
        uiDefaults.put("NumberPicker.font", largeBoldFont);
        uiDefaults.put("TextPicker.font", defaultBoldFont);
        uiDefaults.put("TextPicker.otherFont", smallerBoldFont);
        uiDefaults.put(HEADER_BACKGROUND_UI_KEY, HEADER_BACKGROUND);
        uiDefaults.put(CHECKSUM_FOREGROUND_UI_KEY, Color.WHITE);
        uiDefaults.put("Unit.size", (Object)52);
    }

    private void initializeDefaultWidgets(UIDefaults map) {
        map.put("Separator.background", G5_BLUE);
        map.put("Separator.foreground", G5_BLUE);
        map.put("CardBorder.background", DISABLED_BACKGROUND);
        map.put("CardBorder.foreground", G5_BLACK);
        map.put("TitledBorder.border", BorderFactory.createEmptyBorder(2, 2, 2, 2));
        map.put("textHighlight", UNIVERSAL_ROBOTS_BLUE);
        map.put("selectedWidget", UNIVERSAL_ROBOTS_DARK_BLUE);
        map.put("Tree.selectionBackground", UNIVERSAL_ROBOTS_BLUE);
        map.put("List.selectionBackground", UNIVERSAL_ROBOTS_BLUE);
        map.put("List.background", DEFAULT_BACKGROUND);
        map.put("TextPane.selectionBackground", UNIVERSAL_ROBOTS_BLUE);
        map.put("ComboBoxUI", ComboBoxUI.class.getName());
        map.put("ComboBox.buttonDarkShadow", G5_BLACK);
        map.put("ComboBox.buttonShadow", Color.LIGHT_GRAY);
        map.put("ComboBox.buttonBackground", G5_WHITE);
        map.put("ComboBox.buttonHighlight", G5_WHITE);
        map.put("ComboBox.background", G5_WHITE);
        map.put("ComboBox.selectionBackground", UNIVERSAL_ROBOTS_BLUE);
        map.put("ComboBox.disabledBackground", G5_WHITE);
        map.put("ComboBox.disabledForeground", Color.LIGHT_GRAY);
        map.put("ComboBox.cellHeight", (Object)32);
        map.put("ComboBox.border", new CompoundBorder(ErrorBorder.rightSideError(), new StateBasedBorder()));
        map.put("List.border", LIST_BORDER);
        map.put("undefined.warning", UNDEFINED_WARNING_COLOR);
        map.put("ScrollPane.border", BorderFactory.createEmptyBorder());
        map.put("ScrollPane.opaque", (Object)false);
        map.put("ScrollBarUI", URScrollBarUI.class.getName());
        map.put("ScrollBar.border", BorderFactory.createLineBorder(DISABLED_BACKGROUND));
        map.put("ScrollBar.background", G5_WHITE);
        map.put("ScrollBar.foreground", G5_WHITE);
        map.put("ScrollBar.track", BETWEEN_CARD_COLOR);
        map.put("ScrollBar.thumb", G5_WHITE);
        map.put("ScrollBar.thumbHeight", (Object)33);
        map.put("ScrollBar.thumbHighlight", PRESSED_CONTROL);
        map.put("ScrollBar.width", (Object)33);
        map.put("ScrollBar.squareButtons", (Object)true);
        map.put("SearchButton.border", new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(1, 1, 2, 1)));
        map.put("Table.selectionBackground", G5_BLUE);
        map.put("TableHeader.font", new FontUIResource(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD)));
        map.put("TableHeader.foreground", G5_BLACK);
        map.put("TableHeader.background", DEFAULT_BACKGROUND);
        map.put("TableHeader.cellBorder", BorderFactory.createMatteBorder(0, 0, 2, 0, BETWEEN_CARD_COLOR));
        map.put("DualValueSliderUI", DualSliderUI.class.getName());
        map.put("DualValueSlider.indicatorColor", new Color(51, 153, 255, 128));
        map.put("DualValueSlider.upperLimitColor", new Color(128, 128, 128, 128));
        map.put("SliderUI", URSliderUI.class.getName());
        map.put("Slider.disabledHorizontalThumbIcon", ImageResource.disabledSlider());
        map.put("Slider.disabledVerticalThumbIcon", ImageResource.disabledSlider());
        map.put("Slider.horizontalThumbIcon", ImageResource.slider());
        map.put("Slider.verticalThumbIcon", ImageResource.slider());
        map.put("Slider.foreground", G5_BLACK);
        map.put("Slider.highlight", G5_BLUE);
        map.put("Slider.darkShadow", G5_BLUE);
        map.put("Slider.thumb", G5_BLUE);
        map.put("Slider.altTrackColor", G5_BLUE);
        map.put("Slider.background", DEFAULT_BACKGROUND);
        map.put(SLIDER_TRACK_FILL_COLOR_UI_KEY, G5_DARK_BLUE);
        map.put("Slider.trackWidth", (Object)8);
        map.put("Slider.thumbSize", new Dimension(30, 30));
        map.put("ProgressBarUI", URProgressBarUI.class.getName());
        map.put("ProgressBar.insets", new Insets(2, 2, 2, 2));
        map.put("ProgressBar.border", new CompoundBorder(new RoundedEndsLineBorder(COMPONENT_BACKGROUND, 1), new EmptyBorder(2, 2, 2, 2)));
        map.put("ProgressBar.fillColor", G5_WHITE);
        map.put("ProgressBar.selectionForeground", G5_BLACK);
        map.put("ProgressBar.background", DEFAULT_BACKGROUND);
        map.put("ProgressBar.foreground", G5_DARK_BLUE);
        map.put("ProgressBar.selectionBackground", BETWEEN_CARD_COLOR);
        map.put("DualValueProgressBarUI", DualValueProgressBarUI.class.getName());
        map.put(PANEL_BACKGROUND, DEFAULT_BACKGROUND);
        map.put("Label.background", new Color(230, 230, 230));
        map.put("TextField.border", TEXT_FIELD_BORDER);
        map.put("TextField.background", G5_WHITE);
        map.put("TextField.selectionBackground", UNIVERSAL_ROBOTS_BLUE);
        map.put("ExpressionTextField.enabledBorder", TEXT_FIELD_ENABLED_BORDER);
        map.put("ExpressionTextField.disabledBorder", TEXT_FIELD_BORDER);
        map.put("PasswordField.border", TEXT_FIELD_BORDER);
        map.put("FormattedTextField.border", TEXT_FIELD_BORDER);
        map.put("Button.border", new CompoundBorder(new EnablementMatteBorder(2, 2, 2, 2, UNIVERSAL_ROBOTS_DARK_BLUE, Color.LIGHT_GRAY), new CompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), new BasicBorders.MarginBorder())));
        map.put("Button.background", G5_WHITE);
        map.put("Button.foreground", G5_BLACK);
        map.put("Button.primaryBackgroundColor", UNIVERSAL_ROBOTS_DARK_BLUE);
        map.put("CheckBox.background", DEFAULT_BACKGROUND);
        map.put("CheckBox.border", BorderFactory.createEmptyBorder());
        map.put("CheckBox.focus", new ColorUIResource(G5_BLACK));
        map.put("CheckBox.icon", new UncheckedCheckedIcon(ImageResource.checkbox(), ImageResource.checkboxChecked()));
        map.put("EtchedBorder.background", DEFAULT_BACKGROUND);
        map.put("ToggleButton.border", map.get(PANEL_BACKGROUND));
        map.put("ToggleButton.background", COMPONENT_BACKGROUND);
        map.put("ToggleButton.select", map.get(PANEL_BACKGROUND));
        map.put("ToggleButton.focus", map.get(PANEL_BACKGROUND));
        map.put("RadioButtonUI", URRadioButtonUI.class.getName());
        map.put("RadioButton.background", DEFAULT_BACKGROUND);
        map.put("RadioButton.focus", new ColorUIResource(G5_BLACK));
        map.put("TabbedPaneUI", URTabbedPaneUI.class.getName());
        map.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        map.put("TabbedPaneUI.border", BorderFactory.createEmptyBorder());
        map.put("TabbedPane.tabInsets", new Insets(8, 25, 8, 25));
        map.put("TabbedPane.selected", G5_DARK_BLUE);
        map.put("NumberPicker.dimensions", new Dimension(74, 64));
        map.put("NumberPicker.background", G5_WHITE);
        map.put("NumberPicker.numberKeysColor", G5_WHITE);
        map.put("NumberPicker.otherKeysColor", DISABLED_BACKGROUND);
        map.put("NumberPicker.gapBetween", (Object)2);
        map.put("NumberPicker.borderThickness", (Object)15);
        map.put("NumberPicker.keypadBorder", BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(192, 192, 192), 1), BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        map.put("NumberPicker.inputBorder", BorderFactory.createLineBorder(new Color(192, 192, 192)));
        map.put("NumberPicker.textFieldSelectedBorder", NUMBER_PICKER_TEXT_FIELD_SELECTED_BORDER);
        map.put("TextPicker.dimensions", new Dimension(65, 65));
        map.put("TextPicker.border", BorderFactory.createMatteBorder(10, 120, 10, 120, BETWEEN_CARD_COLOR));
        map.put("ExpressionPicker.outerBorder", BorderFactory.createEmptyBorder());
        map.put("TextPicker.background", BETWEEN_CARD_COLOR);
        map.put("TextPicker.maxWidth", (Object)1020);
        map.put("TextPicker.padding", (Object)5);
        map.put("TextPicker.shiftedKeyColor", new Color(153, 153, 153));
        map.put("TextPicker.shiftKeyLockedColor", G5_BLUE);
        map.put("ExpressionPicker.border", BorderFactory.createMatteBorder(10, 30, 10, 30, BETWEEN_CARD_COLOR));
        map.put("ExpressionPicker.strut", (Object)50);
        map.put("BasicContentViewerUI", BasicContentViewerUI.class.getName());
        map.put(FOOTER_BACKGROUND_COLOR_UI_KEY, FOOTER_BACKGROUND);
        map.put("AccordionView.headerIcon", ImageResource.approve());
        map.put("AccordionView.headerSelectedIcon", ImageResource.cancel());
        map.put("AccordionView.headerForeground", G5_WHITE);
        map.put("AccordionView.headerBackground", G5_DARK_BLUE);
        map.put("AccordionView.headerBorder", BorderFactory.createEmptyBorder());
        map.put("AccordionView.subSectionBackground", new Color(179, 179, 179));
        map.put("AccordionView.subSectionBorder", new MatteBorder(new Insets(0, 25, 0, 0), Color.WHITE));
        map.put("AccordionView.dimensions", new Dimension(200, -1));
        map.put("ScrollPaneBorder", BorderFactory.createLineBorder(G5_BLACK));
        map.put("SmallFontSize", (Object)14);
        map.put("DropDownHeaderForeground", map.get("Button.foreground"));
        map.put("DropDownHeaderBackground", DISABLED_BACKGROUND);
        map.put("DropDownHeaderFontSize", (Object)(this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD).getSize() - 1));
        map.put(ERROR_COLOR_UI_KEY, ERROR_FILL_COLOR);
        map.put(WARNING_COLOR_UI_KEY, WARNING_FILL_COLOR);
        map.put("URDialog.border", new LineBorder(G5_BLACK, 1));
        map.put("URDialog.titleBorder", new EmptyBorder(0, 0, 0, 0));
        map.put("MenuBar.background", HEADER_BACKGROUND);
        map.put("MenuBar.border", new EmptyBorder(0, 0, 0, 0));
        map.put("Menu.background", HEADER_BACKGROUND);
        map.put("Menu.foreground", G5_WHITE);
        map.put("Menu.selectionBackground", G5_DARK_BLUE);
        map.put("Menu.selectionForeground", G5_WHITE);
        map.put("Menu.borderPainted", (Object)false);
        map.put("PopupMenu.background", G5_DARK_BLUE);
        map.put("PopupMenu.border", BorderFactory.createLineBorder(G5_DARK_BLUE, 2));
        map.put("PopupMenu.selectionBackground", G5_BLUE);
        map.put("MenuItem.selectionBackground", UNIVERSAL_ROBOTS_BLUE);
        map.put("MenuItem.selectionForeground", HEADER_BACKGROUND);
        map.put("MenuItem.background", G5_DARK_BLUE);
        map.put("MenuItem.foreground", G5_WHITE);
        map.put("CheckBoxMenuItem.selectionBackground", G5_BLUE);
        map.put("CheckBoxMenuItem.selectionForeground", HEADER_BACKGROUND);
        map.put("CheckBoxMenuItem.background", G5_DARK_BLUE);
        map.put("CheckBoxMenuItem.foreground", G5_WHITE);
        map.put("RadioButtonMenuItem.selectionBackground", G5_BLUE);
        map.put("RadioButtonMenuItem.selectionForeground", HEADER_BACKGROUND);
        map.put("RadioButtonMenuItem.background", G5_DARK_BLUE);
        map.put("RadioButtonMenuItem.foreground", G5_WHITE);
        Font relativeFont = this.fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE);
        Font programContribtionTitleFont = relativeFont.deriveFont((float)((double)relativeFont.getSize2D() - 4.0));
        map.put("ProgramNodeContributionTitle.font", programContribtionTitleFont);
        map.put("ProgramNodeContributionTitle.background", G5_WHITE);
        map.put("ProgramNodeContributionTitle.border", BorderFactory.createEmptyBorder(11, 10, 27, 10));
        map.put("ProgramNodeContributionPanel.dimensions", new Dimension(705, 540));
        map.put("ProgramNodeContributionPanel.border", BorderFactory.createEmptyBorder(0, 10, 5, 10));
        map.put("InstallationContributionTitle.background", DISABLED_BACKGROUND);
        map.put("InstallationContributionTitle.border", BorderFactory.createEmptyBorder(6, 5, 7, 5));
        map.put("InstallationContributionPanel.dimensions", new Dimension(1078, 626));
        map.put("InstallationContributionPanelWithFooter.dimensions", new Dimension(1078, 568));
        map.put("InstallationContributionPanel.border", BorderFactory.createEmptyBorder(10, 10, 10, 10));
        map.put("Footer.background", FOOTER_BACKGROUND);
        map.put("Footer.foreground", G5_WHITE);
        map.put("Header.background", HEADER_BACKGROUND);
        map.put("Header.foreground", G5_WHITE);
        map.put("OnOffSwitchUI", OnOffSwitchUI.class.getName());
        map.put("OnOffSwitch.background", DEFAULT_BACKGROUND);
        map.put("OnOffSwitch.disabledText", Color.LIGHT_GRAY);
        map.put("OnOffSwitch.focus", new ColorUIResource(G5_BLACK));
        map.put("OnOffSwitch.icon", new UncheckedCheckedIcon(ButtonImageResource.toggleOff(), ButtonImageResource.toggleOn()));
        map.put("OnOffSwitchUIGray", OnOffSwitchUIGray.class.getName());
        map.put("OnOffSwitchGray.background", DEFAULT_BACKGROUND);
        map.put("OnOffSwitchGray.disabledText", Color.LIGHT_GRAY);
        map.put("OnOffSwitchGray.focus", new ColorUIResource(G5_BLACK));
        map.put("OnOffSwitchGray.icon", new UncheckedCheckedIcon(ButtonImageResource.toggleOffGray(), ButtonImageResource.toggleOn()));
    }

    private static void initializeDefaultRobotAppearance(UIDefaults uiDefaults) {
        uiDefaults.put("Robot.Canvas", DEFAULT_BACKGROUND);
    }
}

