/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class URProgressBarUI
extends MetalProgressBarUI {
    public static ComponentUI createUI(JComponent component) {
        return new URProgressBarUI();
    }

    protected static Rectangle calculateIntersectionClip(int x, int y, int width, int height, Shape originalClip) {
        Rectangle bounds = originalClip.getBounds();
        SwingUtilities.computeIntersection(x, y, width, height, bounds);
        return bounds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        if (this.progressBar.getOrientation() == 0) {
            if (!c.getComponentOrientation().isLeftToRight()) throw new RuntimeException("Not implemented yet!!");
            int sphereSize = barRectHeight;
            g2.setColor(UIManager.getColor("ProgressBar.fillColor"));
            g2.fillRoundRect(b.left, b.top, barRectWidth + 1, barRectHeight, sphereSize, sphereSize);
            Shape clip = g2.getClip();
            g2.setClip(URProgressBarUI.calculateIntersectionClip(b.left, b.top, amountFull, barRectHeight, clip));
            g2.setColor(this.progressBar.getForeground());
            g2.fillRoundRect(b.left + 1, b.top + 1, barRectWidth - 1, barRectHeight - 1, sphereSize - 1, sphereSize - 1);
            g2.setClip(clip);
        } else {
            int sphereSize = barRectWidth;
            g2.setColor(UIManager.getColor("ProgressBar.fillColor"));
            g2.fillRoundRect(b.left, b.top, barRectWidth + 1, barRectHeight + 1, sphereSize, sphereSize);
            Shape clip = g2.getClip();
            g2.setClip(URProgressBarUI.calculateIntersectionClip(b.left + 1, barRectHeight - amountFull + b.top, barRectWidth - 1, barRectHeight, clip));
            g2.setColor(this.progressBar.getForeground());
            g2.fillRoundRect(b.left + 1, b.top + 1, barRectWidth - 1, barRectHeight - 1, sphereSize - 1, sphereSize - 1);
            g2.setClip(clip);
        }
        if (!this.progressBar.isStringPainted()) return;
        this.paintString(g, b.left, b.top + 1, barRectWidth, barRectHeight, amountFull, b);
    }

    @Override
    public void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Rectangle box = this.getBox(null);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        if (this.progressBar.getOrientation() == 0) {
            if (!c.getComponentOrientation().isLeftToRight()) {
                throw new RuntimeException("Not implemented yet!!");
            }
        } else {
            throw new RuntimeException("Not implemented yet!!");
        }
        int sphereSize = barRectHeight - 1;
        g2.setColor(this.progressBar.getForeground());
        g2.fillRect(b.left + box.x + barRectHeight / 2, 4, 10, sphereSize);
        g2.fillOval(b.left + box.x, b.top + 1, sphereSize, sphereSize);
        g2.fillOval(b.left + box.x + 10, b.top + 1, sphereSize, sphereSize);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return (int)Math.round((double)availableLength / 4.5);
    }

    @Override
    protected void paintString(Graphics g, int x, int y, int width, int height, int amountFull, Insets b) {
        if (this.progressBar.getOrientation() == 0) {
            if (this.progressBar.getComponentOrientation().isLeftToRight()) {
                if (this.progressBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(g, x, y, width, height, this.boxRect.x, this.boxRect.width, b);
                } else {
                    this.paintString(g, x, y, width, height, x, amountFull, b);
                }
            } else {
                this.paintString(g, x, y, width, height, x + width - amountFull, amountFull, b);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(g, x, y, width, height, this.boxRect.y, this.boxRect.height, b);
        } else {
            this.paintString(g, x, y, width, height, y + height - amountFull, amountFull, b);
        }
    }

    private void paintString(Graphics g, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String progressString = this.progressBar.getString();
        g2.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
        Rectangle oldClip = g2.getClipBounds();
        g2.setColor(this.getSelectionForeground());
        if (this.progressBar.getOrientation() == 0) {
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        } else {
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g2.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g2, progressString, x, y, width, height);
            g.drawString(progressString, renderLocation.x, renderLocation.y);
        }
        g2.setClip(oldClip);
    }
}

