/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.URScrollButton;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class URScrollBarUI
extends BasicScrollBarUI {
    private int scrollBarSide = 33;

    public static ComponentUI createUI(JComponent c) {
        return new URScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollBarSide = UIManager.getInt("ScrollBar.width");
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new URScrollButton(orientation, this.scrollBarSide);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new URScrollButton(orientation, this.scrollBarSide);
    }

    @Override
    public BasicScrollBarUI.TrackListener createTrackListener() {
        return new URTrackListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarSide, 48);
        }
        return new Dimension(48, this.scrollBarSide);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarSide, this.scrollBarSide);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D g2d = (Graphics2D)g;
        if (!c.isEnabled()) {
            g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
        }
        super.paintTrack(g, c, trackBounds);
        g2d.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Graphics2D g2d = (Graphics2D)g;
        if (!c.isEnabled()) {
            g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        Color color = this.thumbColor;
        if (this.isDragging) {
            color = this.thumbHighlightColor;
        }
        g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Border border = UIManager.getBorder("ScrollBar.border");
        border.paintBorder(c, g, 0, 0, thumbBounds.width, thumbBounds.height);
        g.setColor(color);
        if (this.scrollbar.getOrientation() == 1) {
            g.fillRect(0, 1, thumbBounds.width, thumbBounds.height - 2);
        } else {
            g.fillRect(1, 0, thumbBounds.width - 2, thumbBounds.height);
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
        g2d.setComposite(AlphaComposite.SrcOver);
    }

    protected class URTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected URTrackListener() {
            super(URScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.refreshTrack();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.refreshTrack();
        }

        private void refreshTrack() {
            Rectangle r = URScrollBarUI.this.getTrackBounds();
            URScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
        }
    }
}

