/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.resources.ButtonImageResource;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class URScrollButton
extends BasicArrowButton {
    private int buttonSide;

    URScrollButton(int direction, int side) {
        super(direction);
        this.buttonSide = side;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (!this.isEnabled()) {
            g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Color color = UIManager.getColor("ScrollBar.thumb");
        if (this.getModel().isPressed()) {
            color = UIManager.getColor("ScrollBar.thumbHighlight");
        }
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        if (this.getDirection() == 1) {
            Icon upArrow = ButtonImageResource.scrollUp();
            int x = width / 2 - upArrow.getIconWidth() / 2;
            int y = height / 2 - upArrow.getIconHeight() / 2 - 1;
            upArrow.paintIcon(this, g, x, y);
        } else if (this.getDirection() == 5) {
            Icon downArrow = ButtonImageResource.scrollDown();
            int x = width / 2 - downArrow.getIconWidth() / 2;
            int y = height / 2 - downArrow.getIconHeight() / 2;
            downArrow.paintIcon(this, g, x, y);
        } else if (this.getDirection() == 7) {
            Icon leftArrow = ButtonImageResource.scrollLeft();
            int x = width / 2 - leftArrow.getIconWidth() / 2 - 1;
            int y = height / 2 - leftArrow.getIconHeight() / 2;
            leftArrow.paintIcon(this, g, x, y);
        } else {
            Icon rightArrow = ButtonImageResource.scrollRight();
            int x = width / 2 - rightArrow.getIconWidth() / 2;
            int y = height / 2 - rightArrow.getIconHeight() / 2;
            rightArrow.paintIcon(this, g, x, y);
        }
        g2d.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public Dimension getPreferredSize() {
        switch (this.getDirection()) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                return new Dimension(this.buttonSide, this.buttonSide);
            }
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

