/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.g5;

import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSliderUI;

public class URSliderUI
extends MetalSliderUI {
    public static final String SLIDER_SHOW_THUMB = "URSlider.ShowThumb";

    public static ComponentUI createUI(JComponent component) {
        JSlider slider = (JSlider)component;
        slider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        slider.putClientProperty(SLIDER_SHOW_THUMB, Boolean.TRUE);
        return new URSliderUI();
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(UIManager.getDimension("Slider.thumbSize"));
    }

    protected Color getTrackColor() {
        if (this.slider.isEnabled()) {
            return this.slider.getClientProperty("fillTrackWithForegroundColor") != null ? this.slider.getForeground() : UIManager.getColor("Slider.trackColor");
        }
        return MetalLookAndFeel.getControlShadow();
    }

    @Override
    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.setColor(this.getTrackColor());
        g.translate(knobBounds.x, knobBounds.y);
        g.fillOval(1, 1, this.getThumbSize().width - 1, this.getThumbSize().height - 1);
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    @Override
    public void paintTrack(Graphics g) {
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - this.getThumbOverhang() - 1;
            trackTop = this.getThumbOverhang();
            trackRight = this.trackRect.width;
        } else {
            trackRight = this.trackRect.width - this.getThumbOverhang();
            trackLeft = trackRight - this.getTrackWidth();
            trackBottom = this.trackRect.height;
        }
        if (this.slider.isEnabled()) {
            g.setColor(G5LookAndFeel.COMPONENT_BACKGROUND);
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int tw = this.getTrackWidth();
        int htw = tw / 2;
        if (this.slider.getOrientation() == 0) {
            g.setColor(UIManager.getColor("Slider.background"));
            g.fillArc(trackLeft, trackTop, tw, tw, 90, 180);
            g.fillRect(trackLeft + htw, trackTop, trackRight - trackLeft - tw + 1, tw);
            g.fillArc(trackRight - tw, trackTop, tw, tw, 90, -180);
            if (this.slider.isEnabled()) {
                g.setColor(G5LookAndFeel.COMPONENT_BACKGROUND);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
            }
            g.drawArc(trackLeft, trackTop, tw, tw, 90, 180);
            g.drawLine(trackLeft + htw, trackTop, trackRight - htw, trackTop);
            g.drawLine(trackLeft + htw, trackBottom, trackRight - htw, trackBottom);
            g.drawArc(trackRight - tw, trackTop, tw, tw, 90, -180);
        } else {
            g.setColor(UIManager.getColor("Slider.background"));
            g.fillArc(trackLeft, trackTop, tw, tw, 0, 180);
            g.fillRect(trackLeft, trackTop + htw, tw, trackBottom - trackTop - tw + 1);
            g.fillArc(trackLeft, trackBottom - tw, tw, tw, 0, -180);
            if (this.slider.isEnabled()) {
                g.setColor(G5LookAndFeel.COMPONENT_BACKGROUND);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
            }
            g.drawArc(trackLeft, trackTop, tw, tw, 0, 180);
            g.drawLine(trackLeft, trackTop + htw, trackLeft, trackBottom - htw);
            g.drawLine(trackRight, trackTop + htw, trackRight, trackBottom - htw);
            g.drawArc(trackLeft, trackBottom - tw, tw, tw, 0, -180);
        }
        int fw = tw - 4;
        int hfw = fw / 2;
        if (this.filledSlider) {
            int middleOfThumb = 0;
            int fillTop = 0;
            int fillLeft = 0;
            int fillBottom = 0;
            int fillRight = 0;
            if (this.slider.getOrientation() == 0) {
                middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
                middleOfThumb -= this.trackRect.x;
                fillTop = trackTop + 2;
                fillBottom = trackBottom - 2;
                if (!this.drawInverted()) {
                    fillLeft = trackLeft + 2;
                    fillRight = middleOfThumb;
                } else {
                    fillLeft = middleOfThumb;
                    fillRight = trackRight - 2;
                }
            } else {
                middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
                middleOfThumb -= this.trackRect.y;
                fillLeft = trackLeft + 2;
                fillRight = trackRight - 2;
                if (!this.drawInverted()) {
                    fillTop = middleOfThumb;
                    fillBottom = trackBottom - 2;
                } else {
                    fillTop = trackTop + 1;
                    fillBottom = middleOfThumb;
                }
            }
            g.setColor(this.getTrackColor());
            if (this.slider.getOrientation() == 0) {
                g.fillOval(fillLeft + 1, fillTop + 1, fw - 1, fw - 1);
                g.fillRect(fillLeft + hfw, fillTop + 1, fillRight - fillLeft - hfw, fillBottom - fillTop - 1);
            } else {
                g.fillOval(fillLeft + 1, fillBottom - fw, fw - 1, fw - 1);
                g.fillRect(fillLeft + 1, fillTop + hfw, fillRight - fillLeft - 1, fillBottom - fillTop - fw);
            }
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }
}

