/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.impl.input;

import com.ur.swing.CompletedListener;
import com.ur.swing.ScreenUtils;
import com.ur.swing.ValueUnchangedListener;
import com.ur.swing.api.input.NumberUserInput;
import com.ur.swing.api.input.UserInputCallback;
import com.ur.swing.api.input.UserInputType;
import com.ur.swing.impl.input.PlainEventDocument;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NumberUserInputImpl
implements NumberUserInput {
    private final ValidationStrategy.Composite validationStrategies = new ValidationStrategy.Composite(new ValidationStrategy[0]);
    private UserInputType userInputType;

    @Inject
    public NumberUserInputImpl() {
    }

    @Override
    public NumberUserInput setUserInputType(UserInputType userInputType) {
        this.userInputType = userInputType;
        return this;
    }

    @Override
    public NumberUserInput addErrorValidator(ValidationStrategy validationStrategy) {
        this.validationStrategies.add(validationStrategy);
        return this;
    }

    @Override
    public void show(JComponent component, String initialValue, final UserInputCallback callback) {
        JTextField textField = new JTextField();
        PlainEventDocument document = new PlainEventDocument();
        textField.setDocument(document);
        textField.setName(NumberPicker.NUMBER_PICKER_TEXTFIELD);
        textField.setText(initialValue);
        textField.selectAll();
        final NumberPicker numberPicker = new NumberPicker(textField, true);
        switch (this.userInputType) {
            case INTEGER: {
                numberPicker.setMode(Mode.WholeNumbers);
                break;
            }
            case POSITIVE_INTEGER: {
                numberPicker.setMode(Mode.PositiveWholeNumbers);
                break;
            }
            case DOUBLE: {
                numberPicker.setMode(Mode.Standard);
                break;
            }
            case POSITIVE_DOUBLE: {
                numberPicker.setMode(Mode.PositiveNumbers);
                break;
            }
            case IP_ADDRESS: {
                numberPicker.setMode(Mode.IP_ADDRESS);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyboard type " + (Object)((Object)this.userInputType));
            }
        }
        numberPicker.setOriginalValue(initialValue);
        numberPicker.setErrorValidationStrategy(this.getValidationStrategy());
        numberPicker.addCompletedListener(new CompletedListener(){

            @Override
            public void requestApply() {
                callback.onOk(numberPicker.getResultValue());
            }

            @Override
            public void requestCancel() {
                callback.onCancel();
            }
        });
        numberPicker.addValueUnchangedListener(new ValueUnchangedListener(){

            @Override
            public void onValueUnchanged(String value) {
                callback.onValueUnchanged(value);
            }
        });
        this.showWhenMainFrameCentered(numberPicker, component);
    }

    private void showWhenMainFrameCentered(final NumberPicker picker, final JComponent component) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                    public boolean itHappened() {
                        return ScreenUtils.isUrGuiCenteredOnScreen();
                    }
                }, (int)1, (TimeUnit)TimeUnit.SECONDS);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        picker.showKeypad(component);
                        NumberUserInputImpl.this.validateDocumentLater(picker);
                    }
                });
            }
        }).start();
    }

    private void validateDocumentLater(final NumberPicker numberPicker) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                numberPicker.validateValue();
            }
        });
    }

    private ValidationStrategy getValidationStrategy() {
        return this.validationStrategies;
    }
}

