/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.impl.input;

import com.ur.swing.CompletedListener;
import com.ur.swing.InputPicker;
import com.ur.swing.ScreenUtils;
import com.ur.swing.api.input.TextUserInput;
import com.ur.swing.api.input.UserInputCallback;
import com.ur.swing.api.input.UserInputType;
import com.ur.swing.text.TextHolder;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TextUserInputImpl
implements TextUserInput {
    private final ValidationStrategy.Composite validationStrategies = new ValidationStrategy.Composite(new ValidationStrategy[0]);
    private UserInputType userInputType;

    @Inject
    public TextUserInputImpl() {
    }

    @Override
    public TextUserInput setUserInputType(UserInputType userInputType) {
        this.userInputType = userInputType;
        return this;
    }

    @Override
    public TextUserInput addErrorValidator(ValidationStrategy validationStrategy) {
        this.validationStrategies.add(validationStrategy);
        return this;
    }

    @Override
    public void show(JComponent component, final String initialValue, final UserInputCallback callback) {
        TextPicker picker = new TextPicker(new TextHolder(){

            @Override
            public String getText() {
                return initialValue;
            }

            @Override
            public void setText(String text) {
                callback.onOk(text);
            }
        }, this.getUserInputType() == UserInputType.PASSWORD);
        picker.setActiveRequest(InputPicker.Request.Cancel);
        picker.setValidationStrategy(this.getValidationStrategy());
        picker.addCompletedListener(new CompletedListener(){

            @Override
            public void requestApply() {
            }

            @Override
            public void requestCancel() {
                callback.onCancel();
            }
        });
        this.showWhenMainFrameCentered(picker, component);
    }

    private void showWhenMainFrameCentered(final TextPicker picker, final JComponent component) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

                    public boolean itHappened() {
                        return ScreenUtils.isUrGuiCenteredOnScreen();
                    }
                }, (int)1, (TimeUnit)TimeUnit.SECONDS);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextUserInputImpl.this.showPicker(picker, component);
                    }
                });
            }
        }).start();
    }

    private void showPicker(TextPicker picker, JComponent component) {
        if (!component.isShowing()) {
            Log.error((String)("Cannot show keyboard for component not showing on screen: " + component));
            return;
        }
        int position = component.getLocationOnScreen().y + component.getHeight();
        picker.showInputPanelAt(component, position);
        this.validateValueWhenMainFrameReady(picker, position);
    }

    private void validateValueWhenMainFrameReady(final TextPicker picker, final int y) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TextUserInputImpl.this.waitUntilPickerVisible(picker);
                picker.setSubmitKeyEnabled(false);
                if (picker.isSlideScreenRequired(y)) {
                    TextUserInputImpl.this.waitUntilScreenSlidedUp();
                }
                TextUserInputImpl.this.validateValueOnInvokeLater(picker);
            }
        }).start();
    }

    private void validateValueOnInvokeLater(final TextPicker picker) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                picker.validateValue();
            }
        });
    }

    private void waitUntilScreenSlidedUp() {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !ScreenUtils.isUrGuiCenteredOnScreen();
            }
        }, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private void waitUntilPickerVisible(final TextPicker picker) {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return picker.isVisible();
            }
        }, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }

    private UserInputType getUserInputType() {
        return this.userInputType;
    }

    private ValidationStrategy getValidationStrategy() {
        return this.validationStrategies;
    }
}

