/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.number;

import com.ur.lang.Defense;
import com.ur.lang.StringUtils;
import com.ur.swing.BindingRegistration;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.LongPressEraseDelegate;
import com.ur.swing.ValueRequest;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.resources.ImageResource;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;

class KeypadPanel
extends URDialogPanel {
    private static final int GAP_BETWEEN_BUTTONS = UIManager.getInt("NumberPicker.gapBetween");
    private static final Color BACKGROUND_COLOR = UIManager.getColor("NumberPicker.background");
    private static final Color OTHER_KEYS = UIManager.getColor("NumberPicker.otherKeysColor");
    private static final Border KEYPAD_BORDER = UIManager.getBorder("NumberPicker.keypadBorder");
    private static final Color NUMBER_KEYS = UIManager.getColor("NumberPicker.numberKeysColor");
    private static final Border INPUT_BORDER = UIManager.getBorder("NumberPicker.inputBorder");
    private final NumberPicker numberPicker;
    private JPanel textFieldPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JTextField numberField;
    private JTextField inputField;
    private BindingRegistration warningBindingRegistration = BindingRegistration.NULL_REGISTRATION;
    private BindingRegistration errorBindingRegistration = BindingRegistration.NULL_REGISTRATION;
    private BindingRegistration bindingRegistration = BindingRegistration.NULL_REGISTRATION;
    private PropertyChangeListener backgroundChangeListener;
    private DocumentListener inputFieldDocumentListener;
    private JLabel textLabel;
    private boolean allowEmptyValue;

    KeypadPanel(NumberPicker numberPicker, JTextField numberField, boolean showTextField, boolean allowEmptyValue) {
        this(numberPicker, numberField, showTextField);
        this.allowEmptyValue = allowEmptyValue;
    }

    KeypadPanel(NumberPicker numberPicker, JTextField numberField, boolean showTextField) {
        boolean hasNoParent;
        this.numberPicker = numberPicker;
        this.numberField = numberField;
        GridBagLayout g = new GridBagLayout();
        this.setLayout(g);
        this.setBackground(BACKGROUND_COLOR == null ? this.getBackground() : BACKGROUND_COLOR);
        this.setBorder(KEYPAD_BORDER == null ? this.getBorder() : KEYPAD_BORDER);
        int rowIndex = 0;
        boolean bl = hasNoParent = numberField.getParent() == null;
        if (hasNoParent) {
            this.inputField = numberField;
            this.textLabel = new JLabel();
            this.textLabel.setHorizontalAlignment(4);
            numberField.setHorizontalAlignment(4);
            this.textFieldPanel = new JPanel();
            this.textFieldPanel.setLayout(new BoxLayout(this.textFieldPanel, 1));
            this.inputField.setBorder(INPUT_BORDER == null ? BorderFactory.createEmptyBorder(0, 0, 4, 0) : INPUT_BORDER);
            int height = (int)((float)NumberPicker.BUTTON_DIMENSIONS.height * 0.75f);
            ValueRequest valueRequest = numberPicker.getValueRequest();
            if (valueRequest != null) {
                JTextArea textArea = new JTextArea(valueRequest.getMessage(), 2, 0);
                textArea.setLineWrap(true);
                textArea.setWrapStyleWord(true);
                textArea.setEditable(false);
                textArea.setOpaque(false);
                JScrollPane scrollPane = new JScrollPane(textArea);
                scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
                this.textFieldPanel.add(scrollPane);
                height += (int)scrollPane.getPreferredSize().getHeight();
            }
            this.textFieldPanel.add(numberField);
            this.textFieldPanel.setPreferredSize(new Dimension(NumberPicker.BUTTON_DIMENSIONS.width, height));
            this.setName(URDialogType.NUMBER_PICKER.getDialogName());
            this.addToPanel(this.textFieldPanel, 0, rowIndex, 4, 1);
            ++rowIndex;
        } else if (showTextField) {
            this.addTextField(rowIndex);
            ++rowIndex;
        }
        this.createClearButton("C", 0, rowIndex);
        this.createEraseButton("<<", 2, rowIndex);
        this.newTextButton("7", 0, ++rowIndex);
        this.newTextButton("8", 1, rowIndex);
        this.newTextButton("9", 2, rowIndex);
        this.createOKButton(3, rowIndex);
        this.newTextButton("4", 0, ++rowIndex);
        this.newTextButton("5", 1, rowIndex);
        this.newTextButton("6", 2, rowIndex);
        this.newTextButton("1", 0, ++rowIndex);
        this.newTextButton("2", 1, rowIndex);
        this.newTextButton("3", 2, rowIndex);
        this.createCancelButton(3, rowIndex);
        this.newTextButton("0", 0, ++rowIndex);
        this.newTextButton(".", 1, rowIndex);
        this.createPlusMinus("\u00b1", 2, rowIndex);
        if (hasNoParent) {
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeypadPanel.this.setReturnValueAndClose(DialogReturnValue.OK);
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeypadPanel.this.setReturnValueAndClose(DialogReturnValue.CANCEL);
                }
            });
        }
        this.requestFocus();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public URDialogType getDialogType() {
        return URDialogType.NUMBER_PICKER;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateOkEnabled();
        this.backgroundChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                KeypadPanel.this.updateOkEnabled();
            }
        };
        this.getActiveTextField().addPropertyChangeListener("background", this.backgroundChangeListener);
        this.inputFieldDocumentListener = new DocumentUpdateListener(){

            @Override
            public void update() {
                JTextField activeTextField = KeypadPanel.this.getActiveTextField();
                if (this.shouldUpdateOkButtonEnabled(activeTextField)) {
                    KeypadPanel.this.updateOkEnabled();
                }
            }

            private boolean shouldUpdateOkButtonEnabled(JTextField activeTextField) {
                boolean enabled;
                boolean bl = enabled = !KeypadPanel.this.okButton.isEnabled() && activeTextField.getBackground().equals(DisplayMessageFactory.OK_COLOR);
                return KeypadPanel.this.allowEmptyValue ? enabled : !activeTextField.getText().isEmpty();
            }
        };
        this.getActiveTextField().getDocument().addDocumentListener(this.inputFieldDocumentListener);
    }

    public boolean isOKButtonEnabled() {
        return this.okButton.isEnabled();
    }

    public void setWarningValidationStrategy(ValidationStrategy validationStrategy) {
        Defense.notNull((Object)this.inputField, (String)"Must have a textfield showing on keypad");
        Defense.notNull((Object)validationStrategy, (String)"Validation strategy cannot be null");
        this.warningBindingRegistration.removeRegistration();
        this.warningBindingRegistration = NumberFieldUtils.bindWarningValidator(this.inputField, validationStrategy);
    }

    public void setErrorValidationStrategy(ValidationStrategy validationStrategy) {
        Defense.notNull((Object)this.inputField, (String)"Must have a textfield showing on keypad");
        Defense.notNull((Object)validationStrategy, (String)"Validation strategy cannot be null");
        this.errorBindingRegistration.removeRegistration();
        this.errorBindingRegistration = NumberFieldUtils.bindErrorValidator(this.inputField, validationStrategy);
    }

    public void setValidationStrategy(ValidationStrategy errorValidation, ValidationStrategy warningValidation, ValidationStrategy nonTypicalValidation) {
        Defense.notNull((Object)this.inputField, (String)"Must have a textfield showing on keypad");
        Defense.notNull((Object)errorValidation, (String)"Error Validation strategy cannot be null");
        Defense.notNull((Object)warningValidation, (String)"Warning Validation strategy cannot be null");
        this.bindingRegistration.removeRegistration();
        this.bindingRegistration = NumberFieldUtils.bindValidator(this.inputField, errorValidation, warningValidation, nonTypicalValidation);
    }

    private void updateOkEnabled() {
        Log.trace((String)("Has error: " + !DisplayMessageFactory.hasError(this.getActiveTextField())));
        boolean disabled = this.allowEmptyValue ? DisplayMessageFactory.hasError(this.getActiveTextField()) : this.inputField.getText().isEmpty() || DisplayMessageFactory.hasError(this.getActiveTextField());
        this.okButton.setEnabled(!disabled);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getActiveTextField().removePropertyChangeListener("background", this.backgroundChangeListener);
        this.getActiveTextField().getDocument().removeDocumentListener(this.inputFieldDocumentListener);
    }

    public void setMode(Mode mode) {
        switch (mode) {
            case Standard: {
                break;
            }
            case PositiveNumbers: 
            case IP_ADDRESS: {
                this.disableKey("\u00b1");
                break;
            }
            case WholeNumbers: {
                this.disableKey(".");
                break;
            }
            case PositiveWholeNumbers: {
                this.disableKey("\u00b1");
                this.disableKey(".");
            }
        }
    }

    public void updateTextFieldToOriginalValue() {
        if (this.isEmbeddedNumberField()) {
            this.inputField.setText(this.numberField.getText());
            this.inputField.selectAll();
        }
    }

    public void setLabelText(String text) {
        Defense.notNull((Object)this.textLabel, (String)"Use widget factory to instatiate a proper NumberField");
        this.textLabel.setText(text);
        if (StringUtils.isNullOrOnlyWhitespace((String)text)) {
            this.textFieldPanel.remove(this.textLabel);
        } else if (this.textLabel.getParent() == null) {
            this.textFieldPanel.add(this.textLabel);
        }
    }

    private void disableKey(String keyLabel) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component each = componentArray[n2];
            if (each instanceof JButton && ((JButton)each).getText().equals(keyLabel)) {
                each.setEnabled(false);
            }
            ++n2;
        }
    }

    private JButton newTextButton(final String text, int x, int y) {
        JButton result = this.createButtonAndAddTextWithAction(text, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JTextField activeTextField = KeypadPanel.this.getActiveTextField();
                activeTextField.replaceSelection(text);
                KeypadPanel.this.requestFocus();
            }
        });
        if (NUMBER_KEYS != null) {
            result.setBackground(NUMBER_KEYS);
        }
        this.addToPanel(result, x, y);
        return result;
    }

    private void addTextField(int y) {
        this.inputField = new JTextField(){

            @Override
            public void setBorder(Border border) {
            }
        };
        this.inputField.setName(NumberPicker.NUMBER_PICKER_TEXTFIELD);
        this.inputField.selectAll();
        this.inputField.setPreferredSize(new Dimension(NumberPicker.BUTTON_DIMENSIONS.width, NumberPicker.BUTTON_DIMENSIONS.height / 2));
        this.inputField.setHorizontalAlignment(4);
        this.addToPanel(this.inputField, 0, y, 4, 1);
    }

    private void createEraseButton(String text, int x, int y) {
        JButton result = this.createButtonAndAddText(text);
        new LongPressEraseDelegate(result, this.getActiveTextField()){

            @Override
            protected boolean isTextSelected() {
                return false;
            }

            @Override
            protected void longPressAction() {
                JTextField activeTextField = KeypadPanel.this.getActiveTextField();
                String activeText = activeTextField.getText();
                if (activeText.length() == 1) {
                    if (activeTextField.getCaretPosition() == 1) {
                        activeTextField.setText("");
                        activeTextField.select(0, 500);
                    }
                    return;
                }
                super.longPressAction();
            }

            @Override
            protected void buttonReleased() {
                KeypadPanel.this.requestFocus();
                JTextField activeTextField = KeypadPanel.this.getActiveTextField();
                String activeText = activeTextField.getText();
                if (activeText.equals("-")) {
                    activeText = "";
                }
                if (activeText.length() == 0) {
                    activeTextField.setText("");
                    KeypadPanel.this.requestFocus();
                    activeTextField.select(0, 500);
                }
                activeTextField.requestFocus();
            }
        };
        if (OTHER_KEYS != null) {
            result.setBackground(OTHER_KEYS);
        }
        this.addToPanel(result, x, y, 2, 1);
    }

    boolean isEmbeddedNumberField() {
        return this.inputField == this.getActiveTextField();
    }

    private void createClearButton(String text, int x, int y) {
        this.clearButton = this.createButtonAndAddTextWithAction(text, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField activeTextField = KeypadPanel.this.getActiveTextField();
                activeTextField.setText("");
                KeypadPanel.this.requestFocus();
                activeTextField.select(0, 500);
                activeTextField.requestFocus();
            }
        });
        this.clearButton.setName(NumberPicker.CLEAR);
        if (OTHER_KEYS != null) {
            this.clearButton.setBackground(OTHER_KEYS);
        }
        this.addToPanel(this.clearButton, x, y, 2, 1);
    }

    private void createPlusMinus(String string, int x, int y) {
        JButton result = this.createButtonAndAddTextWithAction(string, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField activeTextField = KeypadPanel.this.getActiveTextField();
                int start = activeTextField.getSelectionStart();
                int end = activeTextField.getSelectionEnd();
                if (this.isNegativeValue(activeTextField)) {
                    TextFieldUtils.setValueOrText(activeTextField, activeTextField.getText().substring(1));
                    activeTextField.setSelectionStart(start - 1);
                    activeTextField.setSelectionEnd(end - 1);
                } else {
                    TextFieldUtils.setValueOrText(activeTextField, "-" + activeTextField.getText());
                    activeTextField.setSelectionStart(start + 1);
                    activeTextField.setSelectionEnd(end + 1);
                }
                KeypadPanel.this.requestFocus();
            }

            private boolean isNegativeValue(JTextField textField) {
                return textField.getText().startsWith("-");
            }
        });
        result.setName(NumberPicker.NEGATION);
        if (NUMBER_KEYS != null) {
            result.setBackground(NUMBER_KEYS);
        }
        this.addToPanel(result, x, y);
    }

    private void createOKButton(int x, int y) {
        this.okButton = this.createButtonAndAddTextWithAction("", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KeypadPanel.this.inputField != null) {
                    KeypadPanel.this.numberField.setText(KeypadPanel.this.inputField.getText());
                }
                KeypadPanel.this.numberPicker.hideKeypad(NumberPicker.Request.Apply);
            }
        });
        if (OTHER_KEYS != null) {
            this.okButton.setBackground(OTHER_KEYS);
        }
        this.okButton.setIcon(ImageResource.approve());
        this.okButton.setName(NumberPicker.OK);
        this.addToPanel(this.okButton, x, y, 1, 2);
    }

    private void createCancelButton(int x, int y) {
        this.cancelButton = this.createButtonAndAddTextWithAction("", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeypadPanel.this.numberPicker.hideKeypad(NumberPicker.Request.Cancel);
            }
        });
        if (OTHER_KEYS != null) {
            this.cancelButton.setBackground(OTHER_KEYS);
        }
        this.cancelButton.setName(NumberPicker.CANCEL);
        this.cancelButton.setIcon(ImageResource.cancel());
        this.addToPanel(this.cancelButton, x, y, 1, 2);
    }

    private JButton createButtonAndAddText(String text) {
        JButton result = new JButton(text);
        result.setFont(NumberPicker.BOLD_FONT);
        result.setPreferredSize(NumberPicker.BUTTON_DIMENSIONS);
        return result;
    }

    private JButton createButtonAndAddTextWithAction(String text, ActionListener action) {
        JButton result = this.createButtonAndAddText(text);
        result.addActionListener(action);
        return result;
    }

    private void addToPanel(JComponent result, int x, int y) {
        this.addToPanel(result, x, y, 1, 1);
    }

    private void addToPanel(JComponent result, int x, int y, int width, int height) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.insets.set(GAP_BETWEEN_BUTTONS, GAP_BETWEEN_BUTTONS, GAP_BETWEEN_BUTTONS, GAP_BETWEEN_BUTTONS);
        try {
            Dimension preferredSize = result.getPreferredSize();
            result.setPreferredSize(new Dimension(preferredSize.width * width + (width - 1) * (GAP_BETWEEN_BUTTONS * 2), preferredSize.height * height + (height - 1) * (GAP_BETWEEN_BUTTONS * 2)));
        }
        catch (NullPointerException nullPointerException) {}
        this.add((Component)result, constraints);
    }

    private JTextField getActiveTextField() {
        return this.inputField == null ? this.numberField : this.inputField;
    }

    public void clickOkButton() {
        this.okButton.doClick();
    }

    public void clickCancelButton() {
        this.cancelButton.doClick();
    }

    void clickClearButton() {
        this.clearButton.doClick();
    }

    void clickClearButton(int millis) {
        this.clearButton.doClick(millis);
    }

    public JTextField getInputField() {
        return this.inputField;
    }
}

