/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.number;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.swing.BindingRegistration;
import com.ur.swing.BorderEnabler;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.InputView;
import com.ur.swing.StateBasedBorder;
import com.ur.swing.UnitLabelBorder;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.number.OnEditListener;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.ArrayUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class NumberFieldBorderable
extends JTextField
implements InputView,
BorderEnabler {
    private static final DecimalFormat DEFAULT_FORMAT = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.###");
    public static final ValueConverter DUMMY_CONVERTER = new ValueConverter.DoubleConverter(UnitsConverter.NULL_CONVERTER);
    private static final ValueConverter DEFAULT_CONVERTER = new DoubleConverter(UnitsConverter.NULL_CONVERTER);
    private transient Border outerBorder;
    private final transient StateBasedBorder stateBorder;
    private transient ValueConverter converter = DEFAULT_CONVERTER;
    private UnitLabelBorder unitLabelBorder;
    private Mode mode = Mode.Standard;
    private transient ValidationStrategy warningValidationStrategy = ValidationStrategy.ALWAYS_VALID;
    private transient ValidationStrategy errorValidationStrategy = ValidationStrategy.ALWAYS_VALID;
    private transient ValidationStrategy nonTypicalValidationStrategy = ValidationStrategy.ALWAYS_VALID;
    private transient BindingRegistration bindingRegistration = BindingRegistration.NULL_REGISTRATION;
    private Format format = DEFAULT_FORMAT;
    private String restrictionsText;
    private boolean borderEnabled = true;
    private boolean allowEmptyValue;
    private boolean allowToolTip = true;

    public NumberFieldBorderable() {
        this(DEFAULT_CONVERTER);
    }

    public NumberFieldBorderable(ValueConverter converter) {
        this(converter.getUnit());
        this.converter = converter;
        ResetValueWhenInvalidFocusListener valueListener = new ResetValueWhenInvalidFocusListener();
        this.format = converter.getFormat();
        if (this.format == null) {
            this.format = DEFAULT_FORMAT;
        } else if (this.format instanceof DecimalFormat) {
            ((DecimalFormat)this.format).getDecimalFormatSymbols().setMinusSign(DecimalFormatFactory.getDefaultMinusSign());
        }
        this.setErrorValidationStrategy(null);
        this.addMouseListener(new ShowNumberPicker());
        this.addFocusListener(valueListener);
        this.addActionListener(valueListener);
    }

    public NumberFieldBorderable(ValueConverter converter, boolean allowEmptyValue) {
        this(converter);
        this.allowEmptyValue = allowEmptyValue;
    }

    @Deprecated
    public NumberFieldBorderable(String unit) {
        this.unitLabelBorder = new UnitLabelBorder(unit, UIManager.getFont("Label.font"));
        this.stateBorder = new StateBasedBorder(this);
        this.outerBorder = new CompoundBorder(this.unitLabelBorder, this.stateBorder);
        this.setHorizontalAlignment(4);
        super.setBorder(this.outerBorder);
        this.setFocusable(false);
    }

    public void setValueConverter(ValueConverter valueConverter) {
        this.converter = valueConverter == null ? DEFAULT_CONVERTER : valueConverter;
        this.setUnit(this.converter.getUnit());
        this.setFormat(this.converter.getFormat());
    }

    @Override
    public void setConverter(UnitsConverter converter) {
        this.converter = converter == null ? DEFAULT_CONVERTER : new DoubleConverter(converter);
        this.setUnit(this.converter.getUnit());
    }

    public void setValue(Object value) {
        this.setText("" + this.converter.fromModel(value));
    }

    public Object getValue() {
        return this.converter.fromGui(this.getText());
    }

    @Override
    public void setText(String t) {
        if (this.mode == Mode.IP_ADDRESS) {
            super.setText(t);
        } else {
            if (this.allowEmptyValue && t.isEmpty()) {
                super.setText(t);
                return;
            }
            super.setText(this.getFormattedInputTextValue(t));
        }
    }

    private String getFormattedInputTextValue(String text) {
        double defaultValue = PrimitiveUtils.parseDouble((String)this.getText(), (double)0.0);
        double value = PrimitiveUtils.parseDouble((String)text, (double)defaultValue);
        return this.format.format(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled && this.borderEnabled == enabled) {
            return;
        }
        this.borderEnabled = enabled;
        super.setEnabled(enabled);
        this.bindingRegistration.removeRegistration();
        if (enabled) {
            this.setBindingRegistration();
        }
        this.forceValidation();
    }

    @Override
    public void setUnit(String unit) {
        this.unitLabelBorder.setUnit(unit);
        this.repaint();
    }

    public String getUnit() {
        return this.unitLabelBorder.getUnit();
    }

    public void setUnitWidth(int unitWidth) {
        this.unitLabelBorder = new UnitLabelBorder(this.getUnit(), UIManager.getFont("Label.font"), unitWidth);
        this.outerBorder = new CompoundBorder(this.unitLabelBorder, this.stateBorder);
        super.setBorder(this.outerBorder);
    }

    public void setNumberFieldWidth(int containerWidth, int numWidth) {
        int padding = containerWidth - numWidth;
        this.setUnitWidth(padding);
    }

    public void setSelected() {
        this.stateBorder.setSelected();
        this.repaint();
    }

    public void setUnselected() {
        this.stateBorder.setUnselected();
        this.repaint();
    }

    public void setAllowToolTip(boolean allowToolTip) {
        this.allowToolTip = allowToolTip;
    }

    public boolean isAllowToolTip() {
        return this.allowToolTip;
    }

    public void setNonTypicalValidationStrategy(ValidationStrategy ... validationStrategy) {
        this.bindingRegistration.removeRegistration();
        this.nonTypicalValidationStrategy = ArrayUtils.isNullOrEmpty((Object[])validationStrategy) ? ValidationFactory.getNumberValidator() : new ValidationStrategy.Composite(validationStrategy);
        this.setBindingRegistration();
    }

    public ValidationStrategy getNonTypicalValidationStrategy() {
        return this.nonTypicalValidationStrategy;
    }

    @Override
    public void setWarningValidationStrategy(ValidationStrategy ... validationStrategy) {
        this.bindingRegistration.removeRegistration();
        this.warningValidationStrategy = ArrayUtils.isNullOrEmpty((Object[])validationStrategy) ? ValidationFactory.getNumberValidator() : new ValidationStrategy.Composite(validationStrategy);
        this.setBindingRegistration();
    }

    public ValidationStrategy getWarningValidationStrategy() {
        return this.warningValidationStrategy;
    }

    @Override
    public void setErrorValidationStrategy(ValidationStrategy ... validationStrategy) {
        this.bindingRegistration.removeRegistration();
        this.errorValidationStrategy = ArrayUtils.isNullOrEmpty((Object[])validationStrategy) ? ValidationFactory.getNumberValidator() : new ValidationStrategy.Composite(validationStrategy);
        this.setBindingRegistration();
    }

    private void setBindingRegistration() {
        this.bindingRegistration = NumberFieldUtils.bindValidator(this, this.getErrorValidationStrategy(), this.getWarningValidationStrategy(), this.getNonTypicalValidationStrategy());
    }

    public ValidationStrategy getErrorValidationStrategy() {
        return this.errorValidationStrategy;
    }

    public boolean isSelected() {
        return this.stateBorder.isSelected();
    }

    @Override
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public void postActionEvent() {
        if (this.isValidValue()) {
            super.postActionEvent();
        }
    }

    public boolean isValidValue() {
        return this.getErrorValidationStrategy().isValid(this.getText());
    }

    public boolean hasError() {
        return this.getBackground() == DisplayMessageFactory.ERROR_COLOR;
    }

    public boolean hasWarning() {
        return this.getBackground() == DisplayMessageFactory.WARNING_COLOR;
    }

    @Override
    public void setFormat(Format format) {
        Defense.notNull((Object)format, (String)"Must specify a proper NumberFormat");
        this.format = format;
    }

    @Override
    public void setRestrictionsText(String restrictionsText) {
        this.restrictionsText = restrictionsText;
    }

    public void addOnEditListener(OnEditListener editListener) {
        this.listenerList.add(OnEditListener.class, editListener);
    }

    public void forceValidation() {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.errorValidationStrategy.isValid(this.getText())) {
            this.setBackground(DisplayMessageFactory.ERROR_COLOR);
        } else if (!this.warningValidationStrategy.isValid(this.getText())) {
            this.setBackground(DisplayMessageFactory.WARNING_COLOR);
        } else if (!this.nonTypicalValidationStrategy.isValid(this.getText())) {
            this.setBackground(DisplayMessageFactory.INFORMATION_COLOR);
        } else {
            this.setBackground(DisplayMessageFactory.OK_COLOR);
        }
    }

    @Override
    public void setBorderEnabled(boolean enabled) {
        this.borderEnabled = enabled;
    }

    @Override
    public boolean isBorderEnabled() {
        return this.borderEnabled;
    }

    static class DoubleConverter
    implements ValueConverter<String, Double> {
        private UnitsConverter converter;

        public DoubleConverter(UnitsConverter converter) {
            this.converter = converter;
        }

        @Override
        public Double fromGui(String guiValue) {
            double value = PrimitiveUtils.parseDouble((String)guiValue, (double)0.0);
            return this.converter.convertTo(value);
        }

        @Override
        public String fromModel(Double modelValue) {
            return String.valueOf(this.converter.convertFrom(modelValue));
        }

        @Override
        public String getUnit() {
            return this.converter.getUnit();
        }

        @Override
        public Format getFormat() {
            return DEFAULT_FORMAT;
        }
    }

    private class ResetValueWhenInvalidFocusListener
    implements FocusListener,
    ActionListener {
        private String originalValue;

        private ResetValueWhenInvalidFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.originalValue = NumberFieldBorderable.this.getText();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.validateValueOnChange()) {
                NumberFieldBorderable.super.postActionEvent();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.validateValueOnChange();
        }

        private boolean validateValueOnChange() {
            if (EqualsUtil.equals((Object)this.originalValue, (Object)NumberFieldBorderable.this.getText())) {
                return false;
            }
            if (!NumberFieldBorderable.this.isValidValue()) {
                NumberFieldBorderable.this.setText(this.originalValue);
                return false;
            }
            return true;
        }
    }

    private class ShowNumberPicker
    extends MouseAdapter {
        private long timeToWaitAfterClose = System.currentTimeMillis();
        private NumberPicker numberPicker = null;

        private ShowNumberPicker() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!NumberFieldBorderable.this.isEnabled() || !NumberFieldBorderable.this.isEditable()) {
                return;
            }
            if (this.numberPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                final JTextField textField = new JTextField(NumberFieldBorderable.this.getText());
                textField.setName(NumberPicker.NUMBER_PICKER_TEXTFIELD);
                final BindingRegistration registration = NumberFieldUtils.bindValidator(textField, this.withMode(NumberFieldBorderable.this.getErrorValidationStrategy()), NumberFieldBorderable.this.getWarningValidationStrategy(), NumberFieldBorderable.this.getNonTypicalValidationStrategy());
                NumberFieldBorderable.this.stateBorder.setSelected();
                if (NumberFieldBorderable.this.isValidValue()) {
                    NumberFieldBorderable.this.setBackground(UIManager.getColor("textHighlight"));
                }
                OnEditListener[] onEditListenerArray = (OnEditListener[])NumberFieldBorderable.this.listenerList.getListeners(OnEditListener.class);
                int n = onEditListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OnEditListener each = onEditListenerArray[n2];
                    each.requestEdit();
                    ++n2;
                }
                textField.selectAll();
                this.numberPicker = new NumberPicker(textField, true, NumberFieldBorderable.this.allowEmptyValue);
                this.numberPicker.setMode(NumberFieldBorderable.this.getMode());
                this.numberPicker.addCompletedListener(new CompletedListener.Template(){

                    @Override
                    public void requestApply() {
                        NumberFieldBorderable.this.setText(textField.getText());
                        NumberFieldBorderable.this.postActionEvent();
                    }
                });
                this.numberPicker.addCloseListener(new CloseListener(){

                    @Override
                    public void onClose() {
                        ShowNumberPicker.this.numberPicker = null;
                        registration.removeRegistration();
                        ShowNumberPicker.this.timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        NumberFieldBorderable.this.stateBorder.setUnselected();
                        NumberFieldBorderable.this.setBackground(Color.white);
                        NumberFieldBorderable.this.forceValidation();
                    }
                });
                if (!StringUtils.isNullOrOnlyWhitespace((String)NumberFieldBorderable.this.restrictionsText)) {
                    this.numberPicker.setLabelText(NumberFieldBorderable.this.restrictionsText);
                }
                this.numberPicker.showKeypad(NumberFieldBorderable.this);
            }
        }

        private ValidationStrategy withMode(ValidationStrategy errorValidationStrategy) {
            ValidationStrategy.Composite errorRules = new ValidationStrategy.Composite(new ValidationStrategy[0]);
            if (NumberFieldBorderable.this.getMode() == Mode.WholeNumbers) {
                errorRules.add(ValidationFactory.getWholeNumberValidator());
            }
            if (NumberFieldBorderable.this.getMode() == Mode.PositiveNumbers) {
                errorRules.add(ValidationFactory.getPositiveNumberValidator());
            }
            if (NumberFieldBorderable.this.getMode() == Mode.PositiveWholeNumbers) {
                errorRules.add(ValidationFactory.getPositiveNumberValidator());
                errorRules.add(ValidationFactory.getWholeNumberValidator());
            }
            if (NumberFieldBorderable.this.getMode() == Mode.IP_ADDRESS) {
                errorRules.add(ValidationFactory.getIpAddressValidator());
            }
            errorRules.add(errorValidationStrategy);
            return errorRules;
        }
    }
}

