/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.number;

import com.ur.lang.PrimitiveUtils;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.validation.SwingFormValidation;
import com.ur.swing.validation.ValidationDocumentListener;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class NumberFieldUtils {
    private static final Map<JTextField, ValidationStrategy> errorValidators = new WeakHashMap<JTextField, ValidationStrategy>();
    private static final Map<JTextField, ValidationStrategy> warningValidators = new WeakHashMap<JTextField, ValidationStrategy>();
    private static final Map<JTextField, ValidationStrategy> nonTypicalValidators = new WeakHashMap<JTextField, ValidationStrategy>();
    private static final CompletedListener DUMMY_LISTENER = new CompletedListener.Template();

    @Deprecated
    public static BindingRegistration bindNumberPicker(JTextField field, Mode mode) {
        return NumberFieldUtils.bindNumberPicker(field, DUMMY_LISTENER, mode);
    }

    @Deprecated
    public static BindingRegistration bindNumberPicker(final JTextField field, final CompletedListener listener, Mode mode) {
        final Mode actualMode = field instanceof NumberField ? ((NumberField)field).getMode() : mode;
        final MouseAdapter mouseAdapter = new MouseAdapter(){
            private long timeToWaitAfterClose = System.currentTimeMillis();
            private NumberPicker numberPicker = null;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!field.isEnabled()) {
                    return;
                }
                if (this.numberPicker == null && this.timeToWaitAfterClose < System.currentTimeMillis()) {
                    this.numberPicker = new NumberPicker(field, true);
                    ValidationStrategy.Composite errorRules = new ValidationStrategy.Composite(new ValidationStrategy[0]);
                    ValidationStrategy.Composite warningRules = new ValidationStrategy.Composite(new ValidationStrategy[0]);
                    ValidationStrategy.Composite nonTypicalRules = new ValidationStrategy.Composite(new ValidationStrategy[0]);
                    NumberFieldUtils.loadValidators(errorRules, warningRules, nonTypicalRules, field);
                    NumberFieldUtils.loadErrorValidatorsFromModes(errorRules, actualMode);
                    this.numberPicker.setValidationStrategy(errorRules, warningRules, nonTypicalRules);
                    this.numberPicker.setMode(actualMode);
                    this.numberPicker.addCompletedListener(listener);
                    this.numberPicker.addCloseListener(new CloseListener(){

                        @Override
                        public void onClose() {
                            numberPicker = null;
                            timeToWaitAfterClose = System.currentTimeMillis() + 300L;
                        }
                    });
                    this.numberPicker.showKeypad();
                }
            }
        };
        field.addMouseListener(mouseAdapter);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                field.removeMouseListener(mouseAdapter);
            }
        };
    }

    private static void loadValidators(ValidationStrategy.Composite errorRules, ValidationStrategy.Composite warningRules, ValidationStrategy.Composite nonTypicalRules, JTextField field) {
        if (errorValidators.containsKey(field)) {
            errorRules.add(errorValidators.get(field));
        }
        if (warningValidators.containsKey(field)) {
            warningRules.add(warningValidators.get(field));
        }
        if (nonTypicalValidators.containsKey(field)) {
            nonTypicalRules.add(nonTypicalValidators.get(field));
        }
    }

    private static void loadErrorValidatorsFromModes(ValidationStrategy.Composite errorRules, Mode actualMode) {
        if (actualMode == Mode.WholeNumbers) {
            errorRules.add(ValidationFactory.getWholeNumberValidator());
        }
        if (actualMode == Mode.PositiveNumbers) {
            errorRules.add(ValidationFactory.getPositiveNumberValidator());
        }
        if (actualMode == Mode.PositiveWholeNumbers) {
            errorRules.add(ValidationFactory.getPositiveNumberValidator());
            errorRules.add(ValidationFactory.getWholeNumberValidator());
        }
        if (actualMode == Mode.IP_ADDRESS) {
            errorRules.add(ValidationFactory.getIpAddressValidator());
        }
    }

    public static BindingRegistration bindWarningValidator(JTextField numberField, ValidationStrategy strategy) {
        warningValidators.put(numberField, strategy);
        return NumberFieldUtils.bindDocumentValidationListener(numberField, ValidationStrategy.ALWAYS_VALID, strategy, ValidationStrategy.ALWAYS_VALID);
    }

    public static BindingRegistration bindErrorValidator(JTextField numberField, ValidationStrategy strategy) {
        errorValidators.put(numberField, strategy);
        return NumberFieldUtils.bindDocumentValidationListener(numberField, strategy, ValidationStrategy.ALWAYS_VALID, ValidationStrategy.ALWAYS_VALID);
    }

    public static BindingRegistration bindValidator(JTextField numberField, ValidationStrategy errorValidator, ValidationStrategy warningValidator) {
        return NumberFieldUtils.bindValidator(numberField, errorValidator, warningValidator, ValidationStrategy.ALWAYS_VALID);
    }

    public static BindingRegistration bindValidator(JTextField numberField, ValidationStrategy errorValidator, ValidationStrategy warningValidator, ValidationStrategy nonTypicalValidator) {
        errorValidators.put(numberField, errorValidator);
        warningValidators.put(numberField, warningValidator);
        nonTypicalValidators.put(numberField, nonTypicalValidator);
        return NumberFieldUtils.bindDocumentValidationListener(numberField, errorValidator, warningValidator, nonTypicalValidator);
    }

    public static void updateFollowerWhenEnabled(JTextField leaderField, JTextField followerField) {
        String text;
        if (!followerField.isEnabled() && (text = PrimitiveUtils.moveNumberIfLower((String)leaderField.getText(), (String)followerField.getText())) != null) {
            followerField.setText(text);
            if (followerField instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)followerField).commitEdit();
                }
                catch (ParseException parseException) {}
            }
        }
    }

    private static BindingRegistration bindDocumentValidationListener(final JTextField numberField, ValidationStrategy errorValidator, ValidationStrategy warningValidator, ValidationStrategy nonTypicalValidator) {
        final ValidationDocumentListener documentValidator = new ValidationDocumentListener(numberField, errorValidator, warningValidator, nonTypicalValidator);
        numberField.getDocument().addDocumentListener(documentValidator);
        return new BindingRegistration(){

            @Override
            public void removeRegistration() {
                numberField.getDocument().removeDocumentListener(documentValidator);
                numberField.setBackground(Color.WHITE);
            }
        };
    }

    public static void followFieldWhenDisabledAndLeaderLowerThanFollower(final JTextField leaderField, final JTextField followerField, final SwingFormValidation formValidation) {
        FocusAdapter focusListener = new FocusAdapter(){

            private void updateFollowerField() {
                if (!formValidation.hasErrors(leaderField)) {
                    NumberFieldUtils.updateFollowerWhenEnabled(leaderField, followerField);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.updateFollowerField();
            }
        };
        leaderField.addFocusListener(focusListener);
    }

    public static ValidationStrategy getErrorValidator(JTextField textField) {
        return errorValidators.get(textField);
    }
}

