/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.number;

import com.ur.lang.Defense;
import com.ur.lang.EqualsUtil;
import com.ur.lang.PrimitiveUtils;
import com.ur.swing.ApplicationFrameProvider;
import com.ur.swing.CloseListener;
import com.ur.swing.CompletedListener;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.ValueRequest;
import com.ur.swing.ValueUnchangedListener;
import com.ur.swing.dialog.DialogPositionUtils;
import com.ur.swing.dialog.DialogProvider;
import com.ur.swing.dialog.URDialogType;
import com.ur.swing.impl.input.PlainEventDocument;
import com.ur.swing.number.KeypadPanel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.apache.commons.lang3.StringUtils;

public class NumberPicker
extends Observable {
    private static final DialogProvider DIALOG_PROVIDER = new DialogProvider(new ApplicationFrameProvider());
    private static final String ENTER_MAP_KEY = "Enter";
    private static final String ESCAPE_MAP_KEY = "Escape";
    private static DialogPositionUtils.PositionRelativeToAnchor positionToField = DialogPositionUtils.PositionRelativeToAnchor.NONE;
    private static final CompoundBorder SELECTED_COMPONENT_BORDER = new CompoundBorder(new LineBorder(Color.DARK_GRAY, 1), new LineBorder(Color.LIGHT_GRAY, 2));
    public static final String NUMBER_PICKER_TEXTFIELD = "NUMBER_PICKER_TEXTFIELD." + NumberPicker.class.getSimpleName();
    public static final Dimension BUTTON_DIMENSIONS = UIManager.getDimension("NumberPicker.dimensions") != null ? UIManager.getDimension("NumberPicker.dimensions") : new Dimension(42, 24);
    public static final String CANCEL = "CANCEL." + NumberPicker.class.getSimpleName();
    public static final String OK = "OK." + NumberPicker.class.getSimpleName();
    public static final String CLEAR = "CLEAR." + NumberPicker.class.getSimpleName();
    public static final String NEGATION = "NEGATION." + NumberPicker.class.getSimpleName();
    protected static Font BOLD_FONT = UIManager.getFont("NumberPicker.font");
    public static JDialog dialog;
    private final List<CloseListener> closeListeners = new ArrayList<CloseListener>();
    private final InputMap inputMap;
    private final ActionMap actionMap;
    private JDialog screen;
    private ValueRequest valueRequest;
    private KeypadPanel keypadPanel;
    private Border defaultBorder;
    private JTextField numberField;
    private CompletedListener listener = CompletedListener.NULL;
    private ValueUnchangedListener valueUnchangedListener = ValueUnchangedListener.NULL;
    private ComponentListener numberPickerVisibleListener = new NumberPickerVisibleListener();
    private String originalValue;
    private String resultValue;
    private ChangeListener removeOnTabHasChanged;
    private List<JTabbedPane> panesWithListeners = new ArrayList<JTabbedPane>();

    public ValueRequest getValueRequest() {
        return this.valueRequest;
    }

    public NumberPicker(ValueRequest valueRequest) {
        this(valueRequest, new JTextField(), false, false);
    }

    public NumberPicker(JTextField numberField) {
        this(null, numberField, false, false);
    }

    public NumberPicker(JTextField numberField, boolean useTextFieldInPicker) {
        this(null, numberField, useTextFieldInPicker, false);
    }

    public NumberPicker(JTextField numberField, boolean useTextFieldInPicker, boolean allowEmptyValue) {
        this(null, numberField, useTextFieldInPicker, allowEmptyValue);
    }

    private NumberPicker(ValueRequest valueRequest, final JTextField numberField, boolean useTextFieldInPicker, boolean allowEmptyValue) {
        this.valueRequest = valueRequest;
        this.numberField = numberField;
        this.screen = DIALOG_PROVIDER.get();
        this.screen.setName(URDialogType.NUMBER_PICKER.getDialogName());
        this.screen.setResizable(false);
        this.screen.getRootPane().setWindowDecorationStyle(0);
        this.screen.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                Window oppositeWin = e.getOppositeWindow();
                if (oppositeWin != null && SwingUtilities.isDescendingFrom(oppositeWin, NumberPicker.this.screen)) {
                    return;
                }
                if (numberField == null || !numberField.hasFocus()) {
                    NumberPicker.this.hideKeypad(Request.Apply);
                }
                if (numberField != null && !numberField.hasFocus()) {
                    NumberPicker.this.screen.toFront();
                }
            }
        });
        this.removeOnTabHasChanged = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberPicker.this.hideKeypad(Request.Cancel);
            }
        };
        JPanel contentPane = (JPanel)this.screen.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.actionMap = contentPane.getActionMap();
        this.inputMap = contentPane.getInputMap(2);
        this.pressEscapeKey();
        this.pressTabKey();
        this.pressEnterKey();
        this.pressBackspaceKey();
        if (!useTextFieldInPicker) {
            int i = 32;
            while (i < 127) {
                this.pressKey("" + (char)i);
                ++i;
            }
            this.pressDecimalKey();
        }
        if (this.keypadPanel != null) {
            this.screen.getContentPane().remove(this.keypadPanel);
        }
        this.keypadPanel = new KeypadPanel(this, numberField, useTextFieldInPicker, allowEmptyValue);
        this.screen.getContentPane().add((Component)this.keypadPanel.getPanel(), "Center");
        this.mapEnterAndEscape(numberField);
        this.screen.pack();
    }

    private void removeExistingListeners() {
        for (JTabbedPane jTabbedPane : this.panesWithListeners) {
            jTabbedPane.removeChangeListener(this.removeOnTabHasChanged);
        }
        WindowFocusListener[] windowFocusListenerArray = this.screen.getWindowFocusListeners();
        int n = windowFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            WindowFocusListener windowFocusListener = windowFocusListenerArray[n2];
            this.screen.removeWindowFocusListener(windowFocusListener);
            ++n2;
        }
        this.panesWithListeners.clear();
    }

    private void mapEnterAndEscape(JComponent jComponent) {
        InputMap iMap = jComponent.getInputMap(0);
        iMap.put(KeyStroke.getKeyStroke(10, 0), ENTER_MAP_KEY);
        iMap.put(KeyStroke.getKeyStroke(27, 0), ESCAPE_MAP_KEY);
        ActionMap aMap = jComponent.getActionMap();
        aMap.put(ENTER_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean hasError;
                JTextField inputField = NumberPicker.this.keypadPanel.getInputField();
                if (inputField != null && !(hasError = DisplayMessageFactory.hasError(inputField))) {
                    NumberPicker.this.keypadPanel.clickOkButton();
                }
            }
        });
        aMap.put(ESCAPE_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPicker.this.keypadPanel.clickCancelButton();
            }
        });
    }

    private void removeMapEnterAndEscape(JComponent jComponent) {
        InputMap iMap = jComponent.getInputMap(0);
        iMap.clear();
        ActionMap aMap = jComponent.getActionMap();
        aMap.clear();
        this.actionMap.clear();
        this.inputMap.clear();
    }

    public KeypadPanel getKeypadPanelForShowing() {
        return this.keypadPanel;
    }

    public void setMode(Mode mode) {
        this.keypadPanel.setMode(mode);
    }

    public void setLabelText(String labelText) {
        this.keypadPanel.setLabelText(labelText);
    }

    public void setValue(double value) {
        JTextField inputField = this.keypadPanel.getInputField();
        Defense.notNull((Object)inputField, (String)"Textfield cannot be null");
        inputField.setText("" + value);
        inputField.selectAll();
        this.originalValue = inputField.getText();
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public String getResultValue() {
        return this.resultValue;
    }

    public double getValue() {
        JTextField inputField = this.keypadPanel.getInputField();
        Defense.notNull((Object)inputField, (String)"Textfield cannot be null");
        return PrimitiveUtils.parseDouble((String)inputField.getText(), (double)0.0);
    }

    public static boolean isSelected(Object border) {
        return SELECTED_COMPONENT_BORDER.equals(border);
    }

    private void pressTabKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("TAB"), "Tab");
        this.actionMap.put("Tab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPicker.this.hideKeypad(Request.Apply);
                NumberPicker.this.numberField.transferFocus();
            }
        });
    }

    private void pressEnterKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("ENTER"), ENTER_MAP_KEY);
        this.actionMap.put(ENTER_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean hasError;
                JTextField inputField = NumberPicker.this.keypadPanel.getInputField();
                if (inputField != null && !(hasError = DisplayMessageFactory.hasError(inputField))) {
                    NumberPicker.this.numberField.setText(inputField.getText());
                    NumberPicker.this.hideKeypad(Request.Apply);
                }
            }
        });
    }

    private void pressEscapeKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), ESCAPE_MAP_KEY);
        this.actionMap.put(ESCAPE_MAP_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPicker.this.hideKeypad(Request.Cancel);
            }
        });
    }

    private void pressBackspaceKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("BACK_SPACE"), "Backspace");
        this.actionMap.put("Backspace", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPicker.this.backspaceActionPerformed();
            }
        });
    }

    void backspaceActionPerformed() {
        if (this.numberField.getSelectedText() == null) {
            int caretPosition = this.numberField.getCaretPosition();
            this.numberField.select(caretPosition - 1, this.numberField.getCaretPosition());
        }
        this.numberField.replaceSelection(null);
    }

    private void pressKey(final String text) {
        this.inputMap.put(KeyStroke.getKeyStroke(text), text);
        this.actionMap.put(text, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPicker.this.numberField.replaceSelection(text);
            }
        });
    }

    private void pressDecimalKey() {
        this.inputMap.put(KeyStroke.getKeyStroke("PERIOD"), "Period");
        this.actionMap.put("Period", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPicker.this.numberField.replaceSelection(".");
            }
        });
    }

    public synchronized void hideKeypad(Request state) {
        this.removeExistingListeners();
        if (dialog != null && !dialog.isVisible()) {
            return;
        }
        SwingUtilities.invokeLater(new FinalizeNumberPicker());
        boolean hasError = false;
        if (DisplayMessageFactory.hasError(this.numberField) && this.originalValue != null) {
            TextFieldUtils.setValueOrText(this.numberField, this.originalValue);
            hasError = true;
        }
        if (EqualsUtil.equals((Object)this.numberField.getText(), (Object)this.originalValue)) {
            if (state == Request.Apply && !hasError) {
                this.valueUnchangedListener.onValueUnchanged(this.numberField.getText());
            }
            state = Request.Cancel;
        }
        switch (state) {
            case Apply: {
                this.performApply();
                break;
            }
            case Cancel: {
                this.performCancel();
            }
        }
    }

    private void performCancel() {
        if (this.valueRequest != null) {
            this.valueRequest.setReturnValue(null);
        }
        if (this.originalValue != null && !this.keypadPanel.isEmbeddedNumberField()) {
            TextFieldUtils.setValueOrText(this.numberField, this.originalValue);
        }
        this.listener.requestCancel();
    }

    private void performApply() {
        if (this.valueRequest != null) {
            this.valueRequest.setReturnValue(this.numberField.getText().replace(',', '.'));
        }
        this.resultValue = this.numberField.getText();
        this.listener.requestApply();
    }

    public void showKeypad() {
        if (this.valueRequest != null) {
            this.originalValue = "";
            this.screen.setLocationRelativeTo(this.screen.getParent());
        } else {
            this.originalValue = TextFieldUtils.getValueOrText(this.numberField, false);
            this.updateTextFieldToOriginalValueWhenVisible();
            this.defaultBorder = this.numberField.getBorder();
            if (this.numberField instanceof NumberField) {
                ((NumberField)this.numberField).setSelected();
            }
            this.numberField.setBorder(SELECTED_COMPONENT_BORDER);
            JTabbedPane pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, this.numberField);
            while (pane != null) {
                pane.addChangeListener(this.removeOnTabHasChanged);
                this.panesWithListeners.add(pane);
                pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, pane);
            }
            positionToField = DialogPositionUtils.setDialogLocationCloseToAnchor(this.screen, this.numberField);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NumberPicker.this.numberField != null && NumberPicker.this.numberField.isEnabled()) {
                    NumberPicker.this.screen.setVisible(true);
                    NumberPicker.setDialog(NumberPicker.this.screen);
                    NumberPicker.this.numberField.selectAll();
                }
            }
        });
    }

    private void updateTextFieldToOriginalValueWhenVisible() {
        this.screen.addComponentListener(this.numberPickerVisibleListener);
    }

    private void onVisibleUpdateTextFieldToOriginalValue() {
        if (this.keypadPanel != null) {
            this.keypadPanel.updateTextFieldToOriginalValue();
        }
    }

    public void showKeypad(JComponent component) {
        if (!component.isShowing()) {
            Log.error((String)("Cannot show keypad for component not showing on screen: " + component));
            return;
        }
        this.originalValue = TextFieldUtils.getValueOrText(this.numberField, false);
        if (!StringUtils.isEmpty((CharSequence)this.originalValue)) {
            this.updateTextFieldToOriginalValueWhenVisible();
        }
        if (this.numberField instanceof NumberField) {
            ((NumberField)this.numberField).setSelected();
        }
        JTabbedPane pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, component);
        while (pane != null) {
            pane.addChangeListener(this.removeOnTabHasChanged);
            this.panesWithListeners.add(pane);
            pane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, pane);
        }
        positionToField = DialogPositionUtils.setDialogLocationCloseToAnchor(this.screen, component);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NumberPicker.this.numberField != null && NumberPicker.this.numberField.isEnabled()) {
                    NumberPicker.this.screen.setVisible(true);
                    NumberPicker.setDialog(NumberPicker.this.screen);
                }
            }
        });
    }

    public void addCompletedListener(CompletedListener listener) {
        this.listener = listener;
    }

    public void addValueUnchangedListener(ValueUnchangedListener valueUnchangedListener) {
        this.valueUnchangedListener = valueUnchangedListener;
    }

    public void addWindowListener(WindowAdapter windowAdapter) {
        this.screen.addWindowListener(windowAdapter);
    }

    public void addCloseListener(CloseListener closeListener) {
        this.closeListeners.add(closeListener);
    }

    public static boolean isVisible() {
        return dialog != null && dialog.isVisible();
    }

    public static boolean isAbove() {
        return DialogPositionUtils.isAboveAnchor(positionToField);
    }

    public void setWarningValidationStrategy(ValidationStrategy validationStrategy) {
        this.keypadPanel.setWarningValidationStrategy(validationStrategy);
    }

    public void setErrorValidationStrategy(ValidationStrategy validationStrategy) {
        this.keypadPanel.setErrorValidationStrategy(validationStrategy);
    }

    public void setValidationStrategy(ValidationStrategy errorValidation, ValidationStrategy warningValidation, ValidationStrategy nonTypicalValidation) {
        this.keypadPanel.setValidationStrategy(errorValidation, warningValidation, nonTypicalValidation);
    }

    public void validateValue() {
        Document document = this.getKeypadPanelForShowing().getInputField().getDocument();
        if (document instanceof PlainEventDocument) {
            ((PlainEventDocument)document).fireChangeEvent();
        }
    }

    private static synchronized void setDialog(JDialog dialog) {
        NumberPicker.dialog = dialog;
    }

    private class FinalizeNumberPicker
    implements Runnable {
        private FinalizeNumberPicker() {
        }

        @Override
        public void run() {
            if (NumberPicker.this.numberField instanceof NumberField) {
                ((NumberField)NumberPicker.this.numberField).setUnselected();
            } else if (NumberPicker.this.numberField.getBorder() == SELECTED_COMPONENT_BORDER) {
                NumberPicker.this.numberField.setBorder(NumberPicker.this.defaultBorder);
            }
            NumberPicker.this.screen.setVisible(false);
            for (CloseListener closeListener : NumberPicker.this.closeListeners) {
                closeListener.onClose();
            }
            this.onDestroy();
            NumberPicker.setDialog(null);
        }

        private void onDestroy() {
            NumberPicker.this.removeMapEnterAndEscape(NumberPicker.this.numberField);
            NumberPicker.this.closeListeners.clear();
            NumberPicker.this.screen.dispose();
        }
    }

    private class NumberPickerVisibleListener
    implements ComponentListener {
        private NumberPickerVisibleListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            NumberPicker.this.onVisibleUpdateTextFieldToOriginalValue();
            NumberPicker.this.screen.removeComponentListener(this);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    public static enum Request {
        Cancel,
        Apply;

    }
}

