/*
 * Decompiled with CFR 0.152.
 */
package com.ur.swing.number.driver;

import com.ur.swing.JemmyUtils;
import com.ur.swing.dialog.URDialogType;
import com.ur.swing.number.NumberPicker;
import com.ur.util.Waiting;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.util.NameComponentChooser;

public class NumberKeyPadOperator {
    public static final int WAIT_AFTER_BUTTON_PRESS = (int)TimeUnit.MILLISECONDS.toMillis(500L);
    public static final String MAXIMUM_DIALOG_WAIT_TIME = "DialogWaiter.WaitDialogTimeout";
    private static String BACKSPACE_KEY = "<<";
    private JDialogOperator numberPicker;

    public NumberKeyPadOperator() {
        this.numberPicker = new JDialogOperator((ComponentChooser)new VisibleComponentChooser((ComponentChooser)new NameComponentChooser(URDialogType.NUMBER_PICKER.getDialogName())), 0);
    }

    public NumberKeyPadOperator(JTextFieldOperator textField) {
        long dialogWait = Timeouts.getDefault((String)MAXIMUM_DIALOG_WAIT_TIME);
        try {
            Timeouts.setDefault((String)MAXIMUM_DIALOG_WAIT_TIME, (long)5000L);
            TimeoutExpiredException exception = this.tryGetNumberPickerDialog(textField);
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            Timeouts.setDefault((String)MAXIMUM_DIALOG_WAIT_TIME, (long)dialogWait);
        }
    }

    private TimeoutExpiredException tryGetNumberPickerDialog(JTextFieldOperator textField) {
        TimeoutExpiredException exception = null;
        int i = 0;
        while (i < 10) {
            textField.clickMouse();
            try {
                this.numberPicker = new JDialogOperator((ComponentChooser)new VisibleComponentChooser((ComponentChooser)new NameComponentChooser(URDialogType.NUMBER_PICKER.getDialogName())), 0);
                return null;
            }
            catch (TimeoutExpiredException tee) {
                exception = tee;
                JemmyProperties.getCurrentOutput().printLine("Waiting for popup");
                ++i;
            }
        }
        return exception;
    }

    public void typeFullText(String text) {
        boolean isNegativeNumber = false;
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char each = cArray[n2];
            JemmyProperties.getCurrentOutput().printLine("  pressing key: " + each);
            this.ensureNumberPickerIsVisible();
            if (each == '-') {
                isNegativeNumber = true;
            } else {
                this.clickButtonWith("" + each);
            }
            ++n2;
        }
        if (isNegativeNumber) {
            this.clickNegation();
        }
    }

    public void punchInKeypadInvalidValue(String garbageGiven) {
        this.typeFullText(garbageGiven);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !NumberKeyPadOperator.this.isOkButtonEnabled();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
        this.clickCancel();
    }

    public void punchInKeypad(String text) {
        this.typeFullText(text);
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return NumberKeyPadOperator.this.isOkButtonEnabled();
            }
        }, (int)10, (TimeUnit)TimeUnit.SECONDS);
        this.clickOk();
    }

    public void clickBackspace() {
        this.clickButtonWith(BACKSPACE_KEY);
    }

    public void longPressBackSpace(int timeMillis) {
        JButtonOperator jButtonOperator = new JButtonOperator((ContainerOperator)this.numberPicker, BACKSPACE_KEY);
        jButtonOperator.pressMouse();
        Waiting.pause((long)timeMillis, (TimeUnit)TimeUnit.MILLISECONDS);
        jButtonOperator.releaseMouse();
        Waiting.pause((long)WAIT_AFTER_BUTTON_PRESS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public boolean isOkButtonEnabled() {
        return JemmyUtils.getButtonByName(this.numberPicker, NumberPicker.OK).isEnabled();
    }

    private void clickNegation() {
        this.clickButtonWithName(NumberPicker.NEGATION);
    }

    public void clickOk() {
        this.clickButtonWithName(NumberPicker.OK);
    }

    public void clickCancel() {
        this.clickButtonWithName(NumberPicker.CANCEL);
    }

    private void clickButtonWithName(String name) {
        JemmyUtils.getButtonByName(this.numberPicker, name).clickMouse();
        Waiting.pause((long)WAIT_AFTER_BUTTON_PRESS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void clickButtonWith(final String text) {
        new JButtonOperator((ContainerOperator)this.numberPicker, new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JButton && ((JButton)component).getText().equals(text);
            }

            public String getDescription() {
                return text;
            }
        }).clickMouse();
        Waiting.pause((long)WAIT_AFTER_BUTTON_PRESS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void ensureNumberPickerIsVisible() {
        if (!this.numberPicker.isVisible()) {
            this.numberPicker.setVisible(true);
        }
    }

    public void clickClear() {
        this.clickButtonWithName(NumberPicker.CLEAR);
    }

    public void setCaret(int i) {
        this.getPickerField().setCaretPosition(i);
    }

    public void setTextSelection(int start, int stop) {
        JTextField pickerField = this.getPickerField();
        pickerField.select(start, stop);
    }

    public JTextField getPickerField() {
        JComponentOperator componentByName = JemmyUtils.getComponentByName(this.numberPicker, NumberPicker.NUMBER_PICKER_TEXTFIELD);
        return (JTextField)componentByName.getSource();
    }

    private class VisibleComponentChooser
    implements ComponentChooser {
        private ComponentChooser componentChooser;

        public VisibleComponentChooser(ComponentChooser componentChooser) {
            this.componentChooser = componentChooser;
        }

        public boolean checkComponent(Component component) {
            return component.isVisible() && this.componentChooser.checkComponent(component);
        }

        public String getDescription() {
            return String.valueOf(this.componentChooser.getDescription()) + " AND is visible";
        }
    }
}

